/*
 * Easy Network Manager Plugin API
 * Copyright (C) 2008  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License, version 2.1, as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA
 */

#ifndef DCS_EASYNETWORKMANAGER_PLUGIN_H
#define DCS_EASYNETWORKMANAGER_PLUGIN_H

#include "DCSCommon.h"
/** DCS Easy Network Manager operations exposed to clients. */
typedef enum DCS_ENM_Operation_E {
    ENM_INIT_USER_INFO,
	ENM_ALLOCATE_DH_IP,
    ENM_CLOSE_WLAN_CONNECTION,
    ENM_SEARCH_ADAPTER,
    ENM_UP_ADAPTER,
    ENM_DOWN_ADAPTER,
    ENM_IS_EXIST_UP_ADAPTER,
    ENM_IS_EXIST_CONNECT_ADAPTER,
    ENM_CONNECT_AP,
    ENM_GET_AP_LIST,
    ENM_GET_CURRENT_AP,
    ENM_GET_IP_ADDRESS_HLAN,
    ENM_GET_CONNECT_TYPE_HLAN,
    ENM_ENABLE_8021X_AUTHENTICATION,
    ENM_ENABLE_INTERNET_SHARING,
    ENM_OVERWRITE_HOMEPAGE,
    ENM_OVERWRITE_PROXY,
    ENM_GET_NEIGHBORS_INFO,
    ENM_CHANGE_ADDRESS,
    ENM_ENABLE_FILE_AND_PRINTER_SHARE,
    ENM_ENABLE_WINDOWS_FIREWALL,
    ENM_IS_EXIST_ADAPTER,
    ENM_WRITE_FILE,
	NN_START_LISTEN,
	NN_UPZIP_PACKAGE
} DCS_ENM_Operation;

/** DCS Easy Network Manager events dispatchable to clients. */
typedef enum DCS_ENM_Event_E {
	ENM_NETWORK_MODE_CHANGED=DCS_EVENT_NUM_START,
	ENM_NETWORK_STATUS_INFO_CHANGED,
	ENM_MESH_POINT_INFO_CHANGED,
	ENM_MESH_PORTAL_INFO_CHANGED,
	ENM_MESH_CLIENT_INFO_CHANGED,
	ENM_AP_INFO_CHANGED,
	ENM_NEIGHBORS_INFO_CHANGED,
    ENM_APPLY_PROFILE,
    NN_LISTEN_CHANGED
} DCS_ENM_Event;

#endif /* DCS_EASYNETWORKMANAGER_PLUGIN_H */
