
#ifndef _CUSTOM_STATIC_TEXT_H
#define _CUSTOM_STATIC_TEXT_H

#include <wx/stattext.h>
#include <wx/colour.h>

class CustomStaticText : public wxStaticText
{
    DECLARE_DYNAMIC_CLASS(CustomStaticText)

public:
    CustomStaticText();

    CustomStaticText(wxWindow *parent,
            wxWindowID id,
            const wxString& label,
            const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize,
            long style = 0,
            const wxString& name = wxStaticTextNameStr);

	virtual ~CustomStaticText();

	bool Create(wxWindow* parent,
            wxWindowID id,
            const wxString& label,
            const wxPoint& pos = wxDefaultPosition,
            const wxSize& size = wxDefaultSize,
            long style = 0,
            const wxString& name= wxStaticTextNameStr);

	virtual bool HasTransparentBackground() { return true; };
	virtual void OnPaint(wxPaintEvent& event);
    virtual bool SetForegroundColour(const wxColour& colour);

protected:
	wxColour m_textColor;
    void SetTextColor(const wxColour& textColor);

	DECLARE_EVENT_TABLE()
};

#endif // _CUSTOM_STATIC_TEXT_H
