#ifndef _DEVICE_CONTROLLER_H
#define _DEVICE_CONTROLLER_H

#include <wx/dynarray.h>

#include "net.h"

class NetworkDeviceInfo : public wxObject
{
    public:
        NetworkDeviceInfo();
        NetworkDeviceInfo(const NetworkDeviceInfo& copy);
        virtual ~NetworkDeviceInfo();
        wxString GetGuid() const;
        wxString GetDescription() const;
        void SetGuid(const wxString& guid);
        void SetDescription(const wxString& desc);
        ADAPTER_TYPE GetDeviceType() const;

    private:
        wxString m_strGuid;
        wxString m_strDesc;
        ADAPTER_TYPE m_devType;

    friend class Win32NetworkDeviceController;
};

WX_DECLARE_OBJARRAY(NetworkDeviceInfo, NetworkDeviceInfoArray);

#if defined(__WXMSW__)
#include <windows.h>

class Win32NetworkDeviceController
{
    public:
        static Win32NetworkDeviceController* GetCurrentInstance();
        virtual ~Win32NetworkDeviceController();
        NetworkDeviceInfoArray EnumNetworkDevice();
        HANDLE OpenNetworkDevice(const NetworkDeviceInfo& info);
        bool CloseNetworkDevice(HANDLE handle);

    protected:
        Win32NetworkDeviceController();

    private:
        static const int SIZEOF_DEVICE_NAME = 256;
        static Win32NetworkDeviceController* instance;

        bool GetNetworkDeviceInfo(const wxString& keyName, NetworkDeviceInfo* pInfo);
};

#endif // __WXMSW__

#endif // _DEVICE_CONTROLLER_H
