#ifndef _PROFILE_GENERAL_SETTING_H_
#define _PROFILE_GENERAL_SETTING_H_

#include <wx/wxprec.h>
#include <wx/frame.h>
#include <wx/stattext.h>
#include <wx/log.h>
#include <wx/app.h>
#include <wx/checkbox.h>
#include <wx/checklst.h>
#include <wx/msgdlg.h>
#include <wx/radiobox.h>
#include <wx/menu.h>
#include <wx/sizer.h>
#include <wx/wizard.h>
#include <wx/stattext.h>
#include <wx/textctrl.h>
#include <wx/checkbox.h>
#include <wx/statline.h>
#include <wx/panel.h>
#include <wx/statbmp.h>
#include <wx/dialog.h>
#include <wx/combobox.h>
#include <wx/bmpcbox.h>
#include "ProfileOtherSettings.h"
#include "ProfileWirelessSettings.h"
#include "Profile.h"
#include "ProfileManagementControl.h"
#if defined(__WXMSW__)
#include "CustomStaticText.h"
#endif

class ProfileGeneralSettings : public wxWizard
{
public:
    ProfileGeneralSettings(wxWindow* parent);
    virtual ~ProfileGeneralSettings() { };

    bool ShowWizard();
    wxWizardPage *GetFirstPage() const { return m_pagestep1; }
    ProfileList_t GetProfile() const;

//    Profile* m_FatherProfile;
//    ProfileManagerDlg* m_FatherDlg;
//    ProfileEditor *pE;


protected:
    static const long ID_STSTATICLINE;
    static const long ID_PICSTATICBITMAP;
    static const long ID_GSSTATICTEXT;
    static const long ID_DES1STATICTEXT;
    static const long ID_PNSTATICTEXT;
    static const long ID_CONTYPESTATICTEXT;
    static const long ID_NAMETEXTCTRL;
    static const long ID_CONTYPECOMBOBOX;
    static const long ID_NAMECOMBOBOX;
    static const long ID_DISABLECHECKBOX;
    static const long ID_AUTHENTYPETEXTCTRL;
    static const long ID_AUTHCHECKBOX;
    static const long ID_HELP;

private:
    wxStaticLine* m_lineSt1;
    wxComboBox* m_cbbConType;
    wxTextCtrl* m_tcName;
    CustomStaticText* m_textDes1;
    CustomStaticText* m_textGs;
    wxStaticText* m_textPn;
    wxCheckBox* m_checkboxDisable;
    wxStaticBitmap* m_sbPic;
    wxBitmapComboBox* m_cbbName;
    wxStaticText* m_textConType;
    wxBitmap *m_bmpPrfl;
    ProfileWirelessSettings *m_pagestep2;
    ProfileOtherSettings *m_pagestep3;
    wxWizardPageSimple *m_pagestep1;
    static const wxString STR_WIZARD_BACK;
    static const wxString STR_WIZARD_NEXT;
    static const wxString STR_WIZARD_FINISH;

    ProfileList_t m_profileInfo;
    void OnProfileTypeSelected(wxCommandEvent& event);
    void OnWizardChanging(wxWizardEvent& event);
    void OnWizardFinished(wxWizardEvent& event);
    void OnWizardCancel(wxWizardEvent& event);
    void OnContextHelp(wxCommandEvent& event);

    DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_GENERAL_SETTING_H_
