#ifndef _PROFILE_MANAGEMENT_CONTROL_H
#define _PROFILE_MANAGEMENT_CONTROL_H

#include "ProfileEditor.h"
#include <wx/wx.h>
#include "wlan.h"
#include "wlanacmevent.h"
#include "SwitchAdapterEvent.h"
#include "DataCenter.h"
#include "WirelessEvent.h"

#include <vector>
using namespace std;

class ProfileManagementControl : public wxEvtHandler
{
    public:
        ProfileManagementControl();
        virtual ~ProfileManagementControl();

        bool ImportProfile(ProfileList_t& profile);
        bool ExportProfile(ProfileList_t& profile, const wxString& path);
        bool ApplyProfile(const ProfileList_t& profile);
        bool DisconnectCurrentProfile();
        bool RemoveProfile(size_t index);
        ProfileList_t* GetProfile(size_t index);
        ProfileList_t* GetProfile(const wxString& name, bool admin = true);
        bool Contains(const wxString& name);
        bool GetUserProfiles(vector<ProfileList_t>& newVector, bool isAdminUser = false, bool reload = true);
        int GetAdminProfileCount();
        bool ChangePriority(int oldPriority, bool increase = true);
        wxString GetCurrentProfile() const;
        const ProfileList_t& GetCurrentUsedProfile() const;
        bool ConfirmModify(wxArrayString& failedProfiles);
        bool ConfirmModify(const vector<ProfileList_t>* pVector, wxArrayString& failedProfiles);
        void NotifyModeChanged(NETWORK_MODE networkMode);

        bool ReadProfile(ProfileList_t& profile, const wxString& fileName);
        bool InsertNewWirelessProfile(ProfileList_t& profile);
        int CheckWirelessProfileExist(const APStatus& network);
        void StopApplying();

        static const wxString SYSTEM_PROFOLE_DIR;
        static const wxString USER_PROFILE_DIR;
        static const wxString GUEST_PROFILE_DIR;

    protected:
        enum CurrentStatus
        {
            WAITING = 0,
            APPLY_PROFILE = 1,
            DISCONNECT_PROFILE = 2
        };
        CurrentStatus m_status;

    private:
        static const int LAN_CONNECT_TIMER_ID;
        static const int APPLY_TIMER_ID;
        static const int PREPARE_TIMER_ID;
        static const size_t NO_FILES = (size_t)-1;
        static const size_t PROFILE_NAME_LENGTH = 36;
        static const wxChar PATH_SEPARATOR;

        APStatus* m_pToConnect;
        wxString m_strKey;
        ProfileList_t m_profileToApply;
        bool m_isBusy;
        bool m_isStopped;
        int m_iApplyDelay;
        int m_iCurrentProfileIndex;
        wxTimer m_timerLanConnect;
        wxTimer m_timerApply;
        wxTimer m_timerPrepare;

#if defined(__WXMSW__)
        static const int ADDRESS_TIMER_ID;
        wxTimer m_timerAddress;
#endif

        ProfileEditor m_editor;
        wxString m_strCurrentProfile;
        vector<ProfileList_t> m_systemProfiles;
        vector<ProfileList_t> m_userProfiles;
        vector<ProfileList_t> m_GuestProfile;

        bool ApplyProfile(size_t index);
        int GetCurrentProfileIndex() const;

        int GetProfilePriority(const ProfileList_t& profile);
        int ContinueApplyProfile(ProfileList_t& profile);
#if defined(__WXMSW__)
        bool ContinueSetAddress(ProfileList_t& profile);
#endif

        void OnTimer(wxTimerEvent& event);
        void OnTimerPrepare(wxTimerEvent& event);
        void OnWlanConnect(WlanAcmEvent& event);
        void OnAdapterSwitch(SwitchAdapterEvent& event);
        void OnWirelessNetworkChanged(const WirelessSwitchEvent& event);

        bool SetFileWritable(const wxString& fileName);
        bool SaveProfile(ProfileList_t& profile, int priority, bool isAdminUser = false);
        bool LoadProfiles(bool isAdminUser);
        bool LoadSystemProfiles();
        bool LoadUserProfiles();
        bool LoadGuestProfile();
        void InsertProfile(const ProfileList_t& profile, vector<ProfileList_t>* pVector);
        bool PostConnectEvent(bool success, unsigned long errorCode = WLAN_ACM_ERROR_SUCCESS);
        bool PostProfileEvent(bool applySuccess);
        bool WriteProfiles(vector<ProfileList_t>* pVector, const wxString& path, wxArrayString& failedPrifiles);
        void ClearCurrentProfile();

        bool IsCorrectNetwork();

    DECLARE_EVENT_TABLE()
};

#endif // _PROFILE_MANAGEMENT_CONTROL_H
