#include "ProxySettings.h"

//(*InternalHeaders(ProxySettings)
#include <wx/intl.h>
#include <wx/string.h>
#include "ENMApp.h"
//*)
#include <wx/msgdlg.h>
#include "ENMUtil.h"

//(*IdInit(ProxySettings)
const long ProxySettings::ID_TCPROXY = wxNewId();
const long ProxySettings::ID_TCPORT = wxNewId();
const long ProxySettings::ID_BUTTONCANCEL = wxNewId();
const long ProxySettings::ID_BUTTONOK = wxNewId();
const long ProxySettings::ID_STPROXY = wxNewId();
const long ProxySettings::ID_STPORT = wxNewId();
const long ProxySettings::ID_STATICBOX_PROXYSERVER = wxNewId();
const long ProxySettings::ID_PANEL1 = wxNewId();
//*)
const long ProxySettings::ID_HELP = wxNewId();
BEGIN_EVENT_TABLE(ProxySettings,wxDialog)
	//(*EventTable(ProxySettings)
	//*)
END_EVENT_TABLE()

ProxySettings::ProxySettings(wxWindow* parent)
{
	//(*Initialize(ProxySettings)
	Create(parent, wxID_ANY, _("Proxy Settings"), wxDefaultPosition, wxDefaultSize, wxDEFAULT_DIALOG_STYLE, _T("wxID_ANY"));
	SetClientSize(wxSize(344,132));
	Panel1 = new wxPanel(this, ID_PANEL1, wxPoint(0,0), wxSize(360,136), wxTAB_TRAVERSAL, _T("ID_PANEL1"));
	m_TcPcoxy = new wxTextCtrl(Panel1, ID_TCPROXY, wxEmptyString, wxPoint(78,36), wxSize(120,24), 0, wxDefaultValidator, _T("ID_TCPROXY"));
	m_TcPort = new wxTextCtrl(Panel1, ID_TCPORT, wxEmptyString, wxPoint(250,36), wxSize(56,24), 0, wxDefaultValidator, _T("ID_TCPORT"));

    #if defined(__WXMSW__)
	m_BtnOK = new wxButton(Panel1, ID_BUTTONOK, _("OK"), wxPoint(165,96), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTONOK"));
	m_BtnCancel = new wxButton(Panel1, ID_BUTTONCANCEL, _("Cancel"), wxPoint(250,96), wxSize(80,27), 0, wxDefaultValidator, _T("ID_BUTTONCANCEL"));
	#endif
    #if defined(__UNIX__)
	m_BtnOK = new wxButton(Panel1, ID_BUTTONOK, _("OK"), wxPoint(138,86), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BUTTONOK"));
	m_BtnCancel = new wxButton(Panel1, ID_BUTTONCANCEL, _("Cancel"), wxPoint(236,86), wxSize(88,32), 0, wxDefaultValidator, _T("ID_BUTTONCANCEL"));
	#endif

	m_StProxy = new wxStaticText(Panel1, ID_STPROXY, _("Address:"), wxPoint(16,38), wxSize(56,28), 0, _T("ID_STPROXY"));
	m_StPort = new wxStaticText(Panel1, ID_STPORT, _("Port:"), wxPoint(208,38), wxSize(35,24), 0, _T("ID_STPORT"));
	m_StProxyServer = new wxStaticBox(Panel1, ID_STATICBOX_PROXYSERVER, _("Proxy Server"), wxPoint(8,8), wxSize(320,72), 0, _T("ID_STATICBOX_PROXYSERVER"));

	Connect(ID_BUTTONCANCEL,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProxySettings::Onm_BtnCancelClick);
	Connect(ID_BUTTONOK,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProxySettings::Onm_BtnOKClick);
	//*)
	Connect(wxID_ANY,wxEVT_INIT_DIALOG,(wxObjectEventFunction)&ProxySettings::OnInit);
	Connect(ID_HELP,wxEVT_COMMAND_BUTTON_CLICKED,(wxObjectEventFunction)&ProxySettings::OnF1Press);
    wxAcceleratorEntry entries[1];

    entries[0].Set( wxACCEL_NORMAL, WXK_F1, ID_HELP );

    wxAcceleratorTable accel(1, entries);

    SetAcceleratorTable(accel);
}

ProxySettings::~ProxySettings()
{
	//(*Destroy(ProxySettings)
	//*)
}

void ProxySettings::OnInit(wxInitDialogEvent& event)
{
    Center();
    m_TcPcoxy->SetFocus();
}

void ProxySettings::Onm_BtnCancelClick(wxCommandEvent& event)
{
    Close();
}

void ProxySettings::Onm_BtnOKClick(wxCommandEvent& event)
{
    if (m_TcPcoxy->IsEmpty())
    {
        wxMessageDialog msg(this, _("Proxy cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcPcoxy->SetFocus();
        return;
    }
    if (m_TcPort->IsEmpty())
    {
        wxMessageDialog msg(this, _("Port field cannot be empty!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcPort->SetFocus();
        return;
    }
    if ( !ENMUtil::IsOnlyNumber(m_TcPort->GetValue()) )
    {
        wxMessageDialog msg(this, _("You can input only numbers in the Port field!"), _("Message"), wxOK | wxICON_INFORMATION);
        msg.ShowModal();
        m_TcPort->SetFocus();
        return;
    }
    EndModal(wxID_OK);
}

void ProxySettings::OnF1Press(wxCommandEvent& event)
{
#if defined(__UNIX__)
    if(wxFileExists(wxT("/usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf")))
    {
        wxString cmd = wxT("evince /usr/share/EasyNetworkManager/Intel_CMPC2.0_Easy_Network_User_Manual_Ubuntu.pdf --page-label=31");
        //wxExecute(cmd);
    }
#endif
#if defined(__WXMSW__)
    ENMUtil::ShowContextHelp(this, _T("ProxySetting"));
#endif
}
