#include "TaskBarBalloonLAN.h"
#include <wx/msgdlg.h>
#include "ENMApp.h"
#include "CustomStaticText.h"
#if defined(__WXMSW__)
#include <windows.h>
#endif

const long TaskBarBalloonLAN::ID_STATICTEXT_SUCCTIP = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_TYPETIP = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_TYPE = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_SPEEDTIP = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_SPEED = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_STATUSTIP = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_STATUS = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_SIGNALQUALITYTIP = wxNewId();
const long TaskBarBalloonLAN::ID_STATICBITMAP_SIGNALQUALITY = wxNewId();
const long TaskBarBalloonLAN::ID_STATICTEXT_SIGNALQUALITY = wxNewId();
//const long TaskBarBalloonLAN::ID_BTN_CLOSE = wxNewId();
const int WIDTH = 270;
const int HEIGHT = 140;

BEGIN_EVENT_TABLE(TaskBarBalloonLAN, wxBitmapDialog)
//    EVT_BUTTON(ID_BTN_CLOSE, TaskBarBalloonLAN::OnButtonClick)
END_EVENT_TABLE()

#if defined(__UNIX__)
TaskBarBalloonLAN::TaskBarBalloonLAN(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic/balloon_LAN.png"),wxBITMAP_TYPE_PNG),(wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{
    m_SuccTip = new CustomStaticText(this, ID_STATICTEXT_SUCCTIP, _T(""), wxPoint(35,18), wxSize(200,14), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_SuccTip->SetForegroundColour(wxColor(0, 0, 255));
	wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_SuccTip->SetFont(StaticText1Font);
	m_TypeTip = new CustomStaticText(this, ID_STATICTEXT_TYPETIP, _("Type:"), wxPoint(35,72), wxSize(90,14), 0, _T("ID_STATICTEXT_TYPETIP"));
	m_Type = new CustomStaticText(this, ID_STATICTEXT_TYPE, _T(""), wxPoint(150,72), wxSize(96,14), 0, _T("ID_STATICTEXT_TYPE"));
	m_SpeedTip = new CustomStaticText(this, ID_STATICTEXT_SPEEDTIP, _("Speed:"), wxPoint(35,96), wxSize(90,14), 0, _T("ID_STATICTEXT_SPEEDTIP"));
	m_Speed = new CustomStaticText(this, ID_STATICTEXT_SPEED, _T(""), wxPoint(150,96), wxSize(88,14), 0, _T("ID_STATICTEXT_SPEED"));
	m_StatusTip = new CustomStaticText(this, ID_STATICTEXT_STATUSTIP, _("Name:"), wxPoint(35,48), wxSize(90,14), 0, _T("ID_STATICTEXT_STATUSTIP"));
	m_Status = new CustomStaticText(this, ID_STATICTEXT_STATUS, _T(""), wxPoint(150,48), wxSize(88,14), 0, _T("ID_STATICTEXT_STATUS"));

	this->Center();

    const int miniLap = 15;
    wxRect clientRect = ::wxGetClientDisplayRect();
    wxPoint finalPos = wxPoint(clientRect.width - WIDTH - miniLap + clientRect.x, miniLap + clientRect.y);
    this->Move(finalPos);
}
#endif

#if defined(__WXMSW__)
TaskBarBalloonLAN::TaskBarBalloonLAN(wxBitmapDialog *dlg, const wxString &title)
    : wxBitmapDialog(wxBitmap(::wxGetApp().strAppPath + _T("pic\\balloon_LAN.png"),wxBITMAP_TYPE_PNG),(wxWindow*)dlg, (wxWindowID)wxID_ANY, wxEmptyString)
{
    m_SuccTip = new CustomStaticText(this, ID_STATICTEXT_SUCCTIP, _T(""), wxPoint(35,18), wxSize(200,14), 0, _T("ID_STATICTEXT_SUCCTIP"));
	m_SuccTip->SetForegroundColour(wxColor(0, 0, 255));
	wxFont StaticText1Font(11, wxSWISS, wxFONTSTYLE_NORMAL, wxBOLD, false, _T("Arial"), wxFONTENCODING_DEFAULT);
	m_SuccTip->SetFont(StaticText1Font);
	m_TypeTip = new CustomStaticText(this, ID_STATICTEXT_TYPETIP, _("Type:"), wxPoint(35,72), wxSize(90,14), 0, _T("ID_STATICTEXT_TYPETIP"));
	m_Type = new CustomStaticText(this, ID_STATICTEXT_TYPE, _T(""), wxPoint(150,72), wxSize(96,14), 0, _T("ID_STATICTEXT_TYPE"));
	m_SpeedTip = new CustomStaticText(this, ID_STATICTEXT_SPEEDTIP, _("Speed:"), wxPoint(35,96), wxSize(90,14), 0, _T("ID_STATICTEXT_SPEEDTIP"));
	m_Speed = new CustomStaticText(this, ID_STATICTEXT_SPEED, _T(""), wxPoint(150,96), wxSize(88,14), 0, _T("ID_STATICTEXT_SPEED"));
	m_StatusTip = new CustomStaticText(this, ID_STATICTEXT_STATUSTIP, _("Name:"), wxPoint(35,48), wxSize(90,14), 0, _T("ID_STATICTEXT_STATUSTIP"));
	m_Status = new CustomStaticText(this, ID_STATICTEXT_STATUS, _T(""), wxPoint(150,48), wxSize(88,14), 0, _T("ID_STATICTEXT_STATUS"));

	this->Center();
    const int miniLap = 15;
    wxRect clientRect = ::wxGetClientDisplayRect();
    wxPoint finalPos = wxPoint(clientRect.width - WIDTH - miniLap + clientRect.x, clientRect.height - HEIGHT - miniLap + clientRect.y);
    this->Move(finalPos);
    SetWindowLong((HWND)this->m_hWnd, GWL_EXSTYLE, WS_EX_TOOLWINDOW | WS_EX_DLGMODALFRAME);
}
#endif

void TaskBarBalloonLAN::OnPaint(wxPaintEvent& event)
{
    wxPaintDC dc(this);

    int iWidth = 0, iHeight = 0;
    this->GetClientSize( &iWidth, &iHeight );

    wxPen pen(this->GetForegroundColour());
    dc.SetPen(pen);

    wxBrush brush(this->GetBackgroundColour());
    dc.SetBrush(brush);

    dc.Clear();
    dc.DrawRectangle(0,0,iWidth,iHeight);
}

/** showing frame and running timer */
void TaskBarBalloonLAN::showBalloon()
{
    this->Show(false);
    this->Show(true);
    //this->timer->Start(iTimeout,wxTIMER_ONE_SHOT);
}

void TaskBarBalloonLAN::OnClick(wxMouseEvent&)
{
}

void TaskBarBalloonLAN::SetConnectionTip(wxString wxsSuccTip)
{
    m_SuccTip->SetLabel(wxsSuccTip);
}

void TaskBarBalloonLAN::SetConnectionType(wxString wxsType)
{
    m_Type->SetLabel(wxsType);
}

void TaskBarBalloonLAN::SetConnectionSpeed(wxString wxsSpeed)
{
    m_Speed->SetLabel(wxsSpeed);
}

void TaskBarBalloonLAN::SetConnectionStatus(wxString wxsStatus)
{
    m_Status->SetLabel(wxsStatus);
}
