#include <linux/kernel.h>
#include <linux/module.h>
#include <linux/init.h>
#include <linux/pci.h>
#include <linux/platform_device.h>

#define LPC_INTEL_RCBA		0xF0

MODULE_LICENSE("GPL");

static u16 pch_lpc_id_table[] = {
	0x1e57,
	0x1e5d,
        0x1e5e,
};

static struct platform_device *rmhwk_platform_dev;

static struct pci_dev *lpc_pdev = NULL;
static u32 rmhkctl_org;
static int rmhwk_workaround_enable(void)
{
	u32	rcba;
	u32	*rmhwkctl;
	u32	rmhwkctl_address;
	int	i;

	for (i = 0; i < sizeof(pch_lpc_id_table)/sizeof(u16); i++) {
		lpc_pdev = pci_get_subsys(PCI_VENDOR_ID_INTEL,
			pch_lpc_id_table[i], PCI_ANY_ID, PCI_ANY_ID, NULL);

		if (lpc_pdev != NULL)
			break;
	}

	if (lpc_pdev == NULL)
		return -1;

	pci_read_config_dword(lpc_pdev, LPC_INTEL_RCBA,
		&rcba);

	rmhwkctl_address = (rcba & 0xFFFFFFFE) + 0x35B0;
	rmhwkctl = ioremap(rmhwkctl_address, 4);
	rmhkctl_org = *rmhwkctl;
	*rmhwkctl = (*rmhwkctl | 0x22);
	iounmap(rmhwkctl);

	return 0;
}

static int rmhwk_workaround_suspend(struct device *dev)
{
        return 0;
}

static int rmhwk_workaround_resume(struct device *dev)
{
	int retval = 0;
	printk("rmhwk_workaround_resume\n");
	retval = rmhwk_workaround_enable();

        return retval;
}

static struct dev_pm_ops rmhwk_pm_ops = {
	.suspend = rmhwk_workaround_suspend,
	.resume = rmhwk_workaround_resume,
	.restore = rmhwk_workaround_resume,
};

static struct platform_driver rmhwk_workaround_driver = {
	.driver = {
		.name = "rmhwk",
		.owner = THIS_MODULE,
		.pm = &rmhwk_pm_ops,
	},
};

static int __init rmhwk_workaround_init(void)
{
        int err;
	
	printk("initializing rmhwk-workaround module\n");

	err = rmhwk_workaround_enable();
	if (err)
		goto error_platform_register;

	err = platform_driver_register(&rmhwk_workaround_driver);
	if (err) {
		pr_err("Unable to register platform driver.\n");
		goto error_platform_register;
	}

	rmhwk_platform_dev = platform_device_alloc("rmhwk", -1);
	if (!rmhwk_platform_dev) {
		err = -ENOMEM;
		goto err_device_alloc;
	}
	err = platform_device_add(rmhwk_platform_dev);
	if (err)
		goto err_device_add;


	return err;

err_device_add:
	 platform_device_put(rmhwk_platform_dev);
err_device_alloc:
	platform_driver_unregister(&rmhwk_workaround_driver);
error_platform_register:
	return err;
}

static void __exit rmhwk_workaround_exit(void)
{
	u32	rcba;
	u32	*rmhwkctl;
	u32	rmhwkctl_address;

	printk("exiting rmhwk-workaround module\n");
	if (rmhwk_platform_dev) {
		platform_driver_unregister(&rmhwk_workaround_driver);
		platform_device_unregister(rmhwk_platform_dev);
	}

	if (lpc_pdev == NULL)
		return;

	pci_read_config_dword(lpc_pdev, LPC_INTEL_RCBA,
		&rcba);

	rmhwkctl_address = (rcba & 0xFFFFFFFE) + 0x35B0;
	rmhwkctl = ioremap(rmhwkctl_address, 4);
	*rmhwkctl = rmhkctl_org;
	iounmap(rmhwkctl);

	lpc_pdev = NULL;
}


module_init(rmhwk_workaround_init);
module_exit(rmhwk_workaround_exit);
