/******************************************************************************
 *
 * This file is provided under a dual BSD/GPLv2 license.  When using or
 * redistributing this file, you may do so under either license.
 *
 * GPL LICENSE SUMMARY
 *
 * Copyright(c) 2012 - 2013 Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of version 2 of the GNU General Public License as
 * published by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110,
 * USA
 *
 * The full GNU General Public License is included in this distribution
 * in the file called COPYING.
 *
 * Contact Information:
 *  Intel Linux Wireless <ilw@linux.intel.com>
 * Intel Corporation, 5200 N.E. Elam Young Parkway, Hillsboro, OR 97124-6497
 *
 * BSD LICENSE
 *
 * Copyright(c) 2012 - 2013 Intel Corporation. All rights reserved.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *  * Neither the name Intel Corporation nor the names of its
 *    contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
 * "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
 * LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
 * A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT
 * OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
 * DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
 * THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
 * OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *****************************************************************************/

#ifndef __fw_api_debug_h__
#define __fw_api_debug_h__

enum iwl_fw_dbg_print_severity {
	DBG_PRINT_SEVERITY_MASK_SPECIAL		= BIT(0),
	DBG_PRINT_SEVERITY_MASK_ERROR		= BIT(1),
	DBG_PRINT_SEVERITY_MASK_WARNING		= BIT(2),
	DBG_PRINT_SEVERITY_MASK_INFO		= BIT(3),
	DBG_PRINT_SEVERITY_MASK_INFOEX		= BIT(4),
	DBG_PRINT_SEVERITY_MASK_TRACE		= BIT(5),
	DBG_PRINT_SEVERITY_MASK_PERFORMANCE	= BIT(6),
	DBG_PRINT_SEVERITY_MASK_DUMP		= BIT(7),
};


/* to set the num: '<,'>s/,/\=printf('= %d,', line('.') - line("'<")) */
enum iwl_fw_dbg_print_group {
	DBG_PRINT_GROUP_MAC_ARBITER		= 0,
	DBG_PRINT_GROUP_MAC_CONTAINER		= 1,
	DBG_PRINT_GROUP_MAC_BSS			= 2,
	DBG_PRINT_GROUP_MAC_AUX			= 3,
	DBG_PRINT_GROUP_BIND_ARBITER		= 4,
	DBG_PRINT_GROUP_BIND_SCHEDULER		= 5,
	DBG_PRINT_GROUP_TIME_DISPATCHER		= 6,
	DBG_PRINT_GROUP_FSM_INFRA		= 7,
	DBG_PRINT_GROUP_TX_MNG			= 8,
	DBG_PRINT_GROUP_HOST_CMD		= 9,
	DBG_PRINT_GROUP_SCAN			= 10,
	DBG_PRINT_GROUP_MAC_PM			= 11,
	DBG_PRINT_GROUP_RF_KILL			= 12,
	DBG_PRINT_GROUP_ISR			= 13,
	DBG_PRINT_GROUP_TX			= 14,
	DBG_PRINT_GROUP_RX			= 15,
	DBG_PRINT_GROUP_BACKOFF			= 16,
	DBG_PRINT_GROUP_PHY			= 17,
	DBG_PRINT_GROUP_CALIB			= 18,
	DBG_PRINT_GROUP_BT_COEX			= 19,
	DBG_PRINT_GROUP_TM_MSK			= 20,
	DBG_PRINT_GROUP_SMART_FIFO		= 21,
	DBG_PRINT_GROUP_RXTX_STA		= 22,
	DBG_PRINT_GROUP_P2P_DEVICE		= 23,
	DBG_PRINT_GROUP_SOFT_AP			= 24,
	DBG_PRINT_GROUP_LISTENER		= 25,
	DBG_PRINT_GROUP_PIBSS			= 26,
	DBG_PRINT_GROUP_IBSS			= 27,
	DBG_PRINT_GROUP_P2P_CLIENT		= 28,
	DBG_PRINT_GROUP_CLIENT_COMMON		= 29,
	DBG_PRINT_GROUP_P2P_GO			= 30,
	DBG_PRINT_GROUP_IE_SPECIFIC		= 31,
	DBG_PRINT_GROUP_WIMAX_COEX		= 32,
	DBG_PRINT_GROUP_POWER_SAVE		= 33,
	DBG_PRINT_GROUP_D3_MANAGER		= 34,
	DBG_PRINT_GROUP_WOWLAN			= 35,
	DBG_PRINT_GROUP_NETDETECT		= 36,
	DBG_PRINT_GROUP_REMOTE_WAKE		= 37,
	DBG_PRINT_GROUP_MEASUREMENT		= 38,
	DBG_PRINT_GROUP_STATISTICS		= 39,
	DBG_PRINT_GROUP_TEMPERATURE		= 40,
	DBG_PRINT_GROUP_CONTINOUS_TX		= 41,
	DBG_PRINT_GROUP_CW			= 42,
	DBG_PRINT_GROUP_RADIO			= 43,
	DBG_PRINT_GROUP_CALIB_INFRA		= 44,
	DBG_PRINT_GROUP_CALIB_TX_POWER		= 45,
	DBG_PRINT_GROUP_CALIB_PAPD		= 46,
	DBG_PRINT_GROUP_CALIB_RLC		= 47,
	DBG_PRINT_GROUP_CALIB_SENSETIVITY	= 48,
	DBG_PRINT_GROUP_CALIB_DC		= 49,
	DBG_PRINT_GROUP_CALIB_ANT_COUPLING	= 50,
	DBG_PRINT_GROUP_CALIB_BB		= 51,
	DBG_PRINT_GROUP_CALIB_LO		= 52,
	DBG_PRINT_GROUP_CALIB_TXIQ		= 53,
	DBG_PRINT_GROUP_HW_TEST			= 54,
	DBG_PRINT_GROUP_ARC_SUBSYS		= 55,
	DBG_PRINT_GROUP_BG_TASK			= 56,
	DBG_PRINT_GROUP_TIME_MACHINE		= 57,
	DBG_PRINT_GROUP_HAL_APMG		= 58,
	DBG_PRINT_GROUP_HAL_BT_CONNECTIVITY	= 59,
	DBG_PRINT_GROUP_HAL_BUS			= 60,
	DBG_PRINT_GROUP_HAL_CCM			= 61,
	DBG_PRINT_GROUP_HAL_FH			= 62,
	DBG_PRINT_GROUP_HAL_L2P			= 63,
	DBG_PRINT_GROUP_HAL_LEDS		= 64,
	DBG_PRINT_GROUP_HAL_LMPM		= 65,
	DBG_PRINT_GROUP_HAL_MIB			= 66,
	DBG_PRINT_GROUP_HAL_NVM			= 67,
	DBG_PRINT_GROUP_HAL_RXE			= 68,
	DBG_PRINT_GROUP_HAL_RXF			= 69,
	DBG_PRINT_GROUP_HAL_SCD			= 70,
	DBG_PRINT_GROUP_HAL_TIMERS		= 71,
	DBG_PRINT_GROUP_HAL_TRM			= 72,
	DBG_PRINT_GROUP_HAL_TXE			= 73,
	DBG_PRINT_GROUP_HAL_TXF			= 74,
	DBG_PRINT_GROUP_HAL_UART		= 75,
	DBG_PRINT_GROUP_DATA_PARSE		= 76,
	DBG_PRINT_GROUP_MANAGMENT_PARSE		= 77,
	DBG_PRINT_GROUP_INTERNAL_TX		= 78,
	DBG_PRINT_GROUP_MCAST_FILTER		= 79,
	DBG_PRINT_GROUP_ACK_BLOCK_ACK		= 80,
	DBG_PRINT_GROUP_QOS			= 81,
	DBG_PRINT_GROUP_RXTX_FSM		= 82,
	DBG_PRINT_GROUP_SECURITY		= 83,
	DBG_PRINT_GROUP_RESERVED_1		= 84,
	DBG_PRINT_GROUP_TEMP_DEBUG		= 85,
	DBG_PRINT_GROUP_LTR			= 86,
	DBG_PRINT_GROUP_LPRX			= 87,
	DBG_PRINT_GROUP_REGULATORY		= 88,
	DBG_PRINT_GROUP_ASSET_TRACKING		= 89,

	DBG_PRINT_GROUP_MAX_NUM,
}; /*	DBG_PRINT_GROUP_API_E_VER_1 */

enum iwl_fw_dbg_print_channel {
	DBG_PRINT_CHANNEL_HOST_NTFY_MASK	= BIT(0),
	DBG_PRINT_CHANNEL_INTERNAL_BUF_MASK	= BIT(1),
	DBG_PRINT_CHANNEL_DEBUG_MON_MASK	= BIT(2),
};

struct iwl_fw_dbg_print_cmd {
	__le32 dbg_channel_mask;
	u8 severity[];
} __packed; /*	DBG_CONFIG_PRINT_CMD_API_S_VER_1 */

struct iwl_fw_dbg_print_buf {
	__le32 size;
	__le32 wr_indx;
	__le32 rd_indx;
	__le32 dw_cnt;
	__le32 message_count;
	__le32 cyclic_count;
	__le32 abort_count;
	__le32 *print_buffer_ptr;
} __packed; /*	DBG_PRINT_BUFFER_STRUCTURE_API_S_VER_1 */

/**
 * enum iwl_debug_action
 * @DBG_ACTION_INJECT_BAD_CRC:		inject bad CRC in TX
 * @DBG_ACTION_UNUSED_POINT:		currently not in use
 * @DBG_ACTION_SET_DEBUG_ASSERT_MODE:	set conditional assert mode
 *					(1-enable, 0-disable)
 * @DBG_ACTION_SET_DEBUG_TEMPERATURE:	set temperature by software
 * @DBG_ACTION_EXECUTE_DEBUG_HOOK:	execute debug hook function
 * @DBG_ACTION_POWER_DOWN_ALLOW:	allow device power down
 */
enum iwl_debug_action {
	DBG_ACTION_INJECT_BAD_CRC	 = 0x01,
	DBG_ACTION_UNUSED_POINT		 = 0x02,
	DBG_ACTION_SET_DEBUG_ASSERT_MODE = 0x03,
	DBG_ACTION_SET_DEBUG_TEMPERATURE = 0x04,
	DBG_ACTION_EXECUTE_DEBUG_HOOK	 = 0x05,
	DBG_ACTION_POWER_DOWN_ALLOW	 = 0x06,
}; /* DBG_CMD_FLAGS_API_E_VER_1 */

/**
 * struct iwl_debug_cmd - set various debug data ( REPLY_DEBUG_CMD = 0xf0 )
 * @debug_action: debug operation requested from DBG_ACTION_ above
 * @scd_flow: Scheduler flow number for which to apply the TX CRC error pattern
 *            \details Flow number between 0 and 19
 * @hook_id:  Hook ID number to execute
 * @tx_bad_crc_msk: tx crc error pattern
 * @dbg_assert_mode: conditional assert mode \details 1-enable, 0-disable
 * @power_down_allow: 0-disable, 1-enable device power down
 */
struct iwl_debug_cmd {
	__le32 debug_action;
	union {
		__le32 scd_flow;
		__le32 hook_id;
	} debug_data1;
	__le32 tx_bad_crc_msk;
	__le32 dbg_assert_mode;
} __packed; /* DEBUG_CMD_DATA_API_S_VER_1 */

#endif /* __fw_api_debug_h__ */
