/******************************************************************************
 *
 * Copyright(c) 2005 - 2013 Intel Corporation.
 * All rights reserved.
 *
 * LICENSE PLACE HOLDER
 *
 *****************************************************************************/

#ifndef __IWL_IDI_TX_H__
#define __IWL_IDI_TX_H__

#include "iwl-idi.h"

#define IWL_IDI_TX_NUM_CHANNELS		2

/*
 * Initialize the IDI TX component.
 * Should be called as part of the global IDI intialization flow.
 *
 * Returns 0 on success, negative value describing the error otherwise.
 */
int iwl_idi_tx_em_init(void);

/**
 * Free the IDI TX emulation block.
 * All DMA copies should be stopped before the call to this function.
 */
void iwl_idi_tx_em_free(void);

/**
 * Start the IDI TX Emulation.
 * Used mainly for debugging options since the IDI is considered started
 * already on init.
 *
 * Returns 0 on success, negative value describing the error otherwise.
 */
int iwl_idi_tx_em_start(void);

/**
 * Stop the IDI TX Emulation.
 * Used to stop all DMA work on the TX channels.
 * Synchronious function - returns only after all DMA operations are stopped.
 *
 * Returns 0 on success, negative value describing the error otherwise.
 */
int iwl_idi_tx_em_stop(void);

/**
 * Start the  DMA operation on the given TX channel.
 * Since this is called only when a SG linked list is set by the IDI and then
 * the IDI waits for interrupt telling it that the processing has finished,
 * there is no risk of race here - per channel.
 *
 *@channel - The channel to enable the dma in.
 * Returns 0 on success, negative value describing the error otherwise.
 */
int iwl_idi_tx_em_dma_enable(u32 channel);

#endif /*__IWL_IDI_TX_H__*/
