/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: MacabAddressBook.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: ihi $ $Date: 2007/09/13 17:50:33 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_MACAB_ADDRESSBOOK_HXX_
#define _CONNECTIVITY_MACAB_ADDRESSBOOK_HXX_

#ifndef _CONNECTIVITY_MACAB_RECORDS_HXX_
#include "MacabRecords.hxx"
#endif

#ifndef _CONNECTIVITY_MACAB_GROUP_HXX_
#include "MacabGroup.hxx"
#endif

#include <vector>

#include <premac.h>
#include <Carbon/Carbon.h>
#include <AddressBook/ABAddressBookC.h>
#include <postmac.h>

namespace connectivity
{
	namespace macab
	{
		class MacabAddressBook
		{
			protected:
				ABAddressBookRef m_aAddressBook;
				MacabRecords *m_xMacabRecords;
				::std::vector<MacabGroup *> m_xMacabGroups;
				sal_Bool m_bRetrievedGroups;
			private:
				void manageDuplicateGroups(::std::vector<MacabGroup *> _xGroups) const;
			public:
				MacabAddressBook();
				~MacabAddressBook();
				static const ::rtl::OUString & getDefaultTableName();

				MacabRecords *getMacabRecords();
				::std::vector<MacabGroup *> getMacabGroups();

				MacabGroup *getMacabGroup(::rtl::OUString _groupName);
				MacabRecords *getMacabRecords(const ::rtl::OUString _tableName);

				MacabGroup *getMacabGroupMatch(::rtl::OUString _groupName);
				MacabRecords *getMacabRecordsMatch(const ::rtl::OUString _tableName);
		};
		
	}
}

#endif // _CONNECTIVITY_MACAB_ADDRESSBOOK_HXX_
