/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: XMLDetectiveContext.hxx,v $
 *
 *  $Revision: 1.10.618.1 $
 *
 *  last change: $Author: kz $ $Date: 2008/01/18 11:47:28 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef _SC_XMLDETECTIVECONTEXT_HXX
#define _SC_XMLDETECTIVECONTEXT_HXX

#ifndef _XMLOFF_XMLIMP_HXX
#include <xmloff/xmlimp.hxx>
#endif

#ifndef _COM_SUN_STAR_TABLE_CELLRANGEADDRESS_HPP_
#include <com/sun/star/table/CellRangeAddress.hpp>
#endif

#ifndef SC_DETFUNC_HXX
#include "detfunc.hxx"
#endif
#ifndef SC_DETDATA_HXX
#include "detdata.hxx"
#endif

#include <list>

class ScXMLImport;


//___________________________________________________________________

struct ScMyImpDetectiveObj
{
	ScRange						aSourceRange;
	ScDetectiveObjType			eObjType;
	sal_Bool					bHasError;

								ScMyImpDetectiveObj();
};

typedef ::std::vector< ScMyImpDetectiveObj > ScMyImpDetectiveObjVec;


//___________________________________________________________________

struct ScMyImpDetectiveOp
{
	ScAddress					aPosition;
	ScDetOpType					eOpType;
	sal_Int32					nIndex;

	inline						ScMyImpDetectiveOp() : nIndex( -1 )	{}
	sal_Bool					operator<(const ScMyImpDetectiveOp& rDetOp) const;
};

typedef ::std::list< ScMyImpDetectiveOp > ScMyImpDetectiveOpList;

class ScMyImpDetectiveOpArray
{
private:
	ScMyImpDetectiveOpList		aDetectiveOpList;

public:
	inline						ScMyImpDetectiveOpArray() :
									aDetectiveOpList()	{}

	inline void					AddDetectiveOp( const ScMyImpDetectiveOp& rDetOp )
									{ aDetectiveOpList.push_back( rDetOp ); }

	void						Sort();
	sal_Bool					GetFirstOp( ScMyImpDetectiveOp& rDetOp );
};


//___________________________________________________________________

class ScXMLDetectiveContext : public SvXMLImportContext
{
private:
	ScMyImpDetectiveObjVec*		pDetectiveObjVec;

	const ScXMLImport&			GetScImport() const	{ return (const ScXMLImport&)GetImport(); }
	ScXMLImport&				GetScImport()		{ return (ScXMLImport&)GetImport(); }

public:
								ScXMLDetectiveContext(
									ScXMLImport& rImport,
									USHORT nPrfx,
									const ::rtl::OUString& rLName,
									ScMyImpDetectiveObjVec* pNewDetectiveObjVec
									);
	virtual						~ScXMLDetectiveContext();

	virtual SvXMLImportContext*	CreateChildContext(
									USHORT nPrefix,
									const ::rtl::OUString& rLocalName,
									const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList
									);
	virtual void				EndElement();
};


//___________________________________________________________________

class ScXMLDetectiveHighlightedContext : public SvXMLImportContext
{
private:
	ScMyImpDetectiveObjVec*		pDetectiveObjVec;
	ScMyImpDetectiveObj			aDetectiveObj;
	sal_Bool					bValid;

	const ScXMLImport&			GetScImport() const	{ return (const ScXMLImport&)GetImport(); }
	ScXMLImport&				GetScImport()		{ return (ScXMLImport&)GetImport(); }

public:
								ScXMLDetectiveHighlightedContext(
									ScXMLImport& rImport,
									USHORT nPrfx,
									const ::rtl::OUString& rLName,
									const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList,
									ScMyImpDetectiveObjVec* pNewDetectiveObjVec
									);
	virtual						~ScXMLDetectiveHighlightedContext();

	virtual SvXMLImportContext*	CreateChildContext(
									USHORT nPrefix,
									const ::rtl::OUString& rLocalName,
									const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList
									);
	virtual void				EndElement();
};


//___________________________________________________________________

class ScXMLDetectiveOperationContext : public SvXMLImportContext
{
private:
	ScMyImpDetectiveOp			aDetectiveOp;
	sal_Bool					bHasType;

	const ScXMLImport&			GetScImport() const	{ return (const ScXMLImport&)GetImport(); }
	ScXMLImport&				GetScImport()		{ return (ScXMLImport&)GetImport(); }

public:
								ScXMLDetectiveOperationContext(
									ScXMLImport& rImport,
									USHORT nPrfx,
									const ::rtl::OUString& rLName,
									const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList
									);
	virtual						~ScXMLDetectiveOperationContext();

	virtual SvXMLImportContext*	CreateChildContext(
									USHORT nPrefix,
									const ::rtl::OUString& rLocalName,
									const ::com::sun::star::uno::Reference< ::com::sun::star::xml::sax::XAttributeList >& xAttrList
									);
	virtual void				EndElement();
};


#endif

