/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: graphsh.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: ihi $ $Date: 2006/11/14 15:53:30 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sc.hxx"



//------------------------------------------------------------------

#include <sfx2/app.hxx>
#include <sfx2/objface.hxx>
#include <sfx2/request.hxx>
#include <svtools/whiter.hxx>
#include <svx/svdograf.hxx>
#include <svx/grfflt.hxx>
#include <svx/grafctrl.hxx>

#include "graphsh.hxx"
#include "sc.hrc"
#include "viewdata.hxx"
#include "drawview.hxx"
#include "scresid.hxx"

#define ScGraphicShell
#include "scslots.hxx"

#define ITEMVALUE(ItemSet,Id,Cast) ((const Cast&)(ItemSet).Get(Id)).GetValue()


SFX_IMPL_INTERFACE(ScGraphicShell, ScDrawShell, ScResId(SCSTR_GRAPHICSHELL) )
{
	SFX_OBJECTBAR_REGISTRATION( SFX_OBJECTBAR_OBJECT|SFX_VISIBILITY_STANDARD|SFX_VISIBILITY_SERVER,
								ScResId(RID_GRAPHIC_OBJECTBAR) );
	SFX_POPUPMENU_REGISTRATION( ScResId(RID_POPUP_GRAPHIC) );
}

TYPEINIT1( ScGraphicShell, ScDrawShell );

ScGraphicShell::ScGraphicShell(ScViewData* pData) :
	ScDrawShell(pData)
{
	SetHelpId(HID_SCSHELL_GRAPHIC);
	SetName(String::CreateFromAscii(RTL_CONSTASCII_STRINGPARAM("GraphicObject")));
}

ScGraphicShell::~ScGraphicShell()
{
}

void ScGraphicShell::GetAttrState( SfxItemSet& rSet )
{
	ScDrawView* pView = GetViewData()->GetScDrawView();

	if( pView )
		SvxGrafAttrHelper::GetGrafAttrState( rSet, *pView );
}

void ScGraphicShell::Execute( SfxRequest& rReq )
{
	ScDrawView* pView = GetViewData()->GetScDrawView();

	if( pView )
	{
		SvxGrafAttrHelper::ExecuteGrafAttr( rReq, *pView );
		Invalidate();
	}
}

void ScGraphicShell::GetFilterState( SfxItemSet& rSet )
{
	ScDrawView* pView = GetViewData()->GetScDrawView();
	const SdrMarkList& rMarkList = pView->GetMarkedObjectList();
	BOOL bEnable = FALSE;

	if( rMarkList.GetMarkCount() == 1 )
	{
		SdrObject* pObj = rMarkList.GetMark( 0 )->GetMarkedSdrObj();

		if( pObj && pObj->ISA( SdrGrafObj ) && ( ( (SdrGrafObj*) pObj )->GetGraphicType() == GRAPHIC_BITMAP ) )
			bEnable = TRUE;
	}

	if( !bEnable )
		SvxGraphicFilter::DisableGraphicFilterSlots( rSet );
}

void ScGraphicShell::ExecuteFilter( SfxRequest& rReq )
{
	ScDrawView* pView = GetViewData()->GetScDrawView();
	const SdrMarkList& rMarkList = pView->GetMarkedObjectList();

	if( rMarkList.GetMarkCount() == 1 )
	{
		SdrObject* pObj = rMarkList.GetMark( 0 )->GetMarkedSdrObj();

		if( pObj && pObj->ISA( SdrGrafObj ) && ( (SdrGrafObj*) pObj )->GetGraphicType() == GRAPHIC_BITMAP )
		{
			GraphicObject aFilterObj( ( (SdrGrafObj*) pObj )->GetGraphicObject() );

			if( SVX_GRAPHICFILTER_ERRCODE_NONE ==
				SvxGraphicFilter::ExecuteGrfFilterSlot( rReq, aFilterObj ) )
			{
				SdrPageView* pPageView = pView->GetSdrPageView();

				if( pPageView )
				{
					SdrGrafObj*	pFilteredObj = (SdrGrafObj*) pObj->Clone();
					String		aStr( pView->GetDescriptionOfMarkedObjects() );

					aStr.Append( sal_Unicode(' ') );
					aStr.Append( String( ScResId( SCSTR_UNDO_GRAFFILTER ) ) );
					pView->BegUndo( aStr );
					pFilteredObj->SetGraphicObject( aFilterObj );
					pView->ReplaceObjectAtView( pObj, *pPageView, pFilteredObj );
					pView->EndUndo();
				}
			}
		}
	}

	Invalidate();
}

