/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: OfficeMasterStyles.java,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/07/09 11:56:07 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2007 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *    Copyright 2007 by Pentaho Corporation
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/


package com.sun.star.report.pentaho.model;

import java.util.HashMap;

import org.jfree.report.structure.Element;
import org.jfree.report.structure.Section;

/**
 * The master-styles section can have either a master-page, handout-master
 * or draw-layer-set. (The latter ones are ignored for the reporting purposes,
 * they are PowerPoint related.)
 *
 * There is no documentation how the system selects a master-page if there is
 * no master-page assigned to the paragraph. However, it seems as if the
 * master-page called 'Standard' is used as initial default.
 *
 * @author Thomas Morgner
 * @since 13.03.2007
 */
public class OfficeMasterStyles extends Element
{
  private HashMap masterPages;
  private Section otherNodes;

  public OfficeMasterStyles()
  {
    masterPages = new HashMap();
    otherNodes = new Section();
  }

  public void addMasterPage (final OfficeMasterPage masterPage)
  {
    if (masterPage == null)
    {
      throw new NullPointerException();
    }
    this.masterPages.put(masterPage.getStyleName(), masterPage);
  }

  public OfficeMasterPage getMasterPage (final String name)
  {
    return (OfficeMasterPage) masterPages.get (name);
  }

  public OfficeMasterPage[] getAllMasterPages()
  {
    return (OfficeMasterPage[]) masterPages.values().toArray
        (new OfficeMasterPage[masterPages.size()]);
  }

  public Section getOtherNodes()
  {
    return otherNodes;
  }
}
