/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: xmlImage.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: ihi $ $Date: 2007/11/20 19:02:32 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/
#include "precompiled_reportdesign.hxx"

#ifndef RPT_XMLIMAGE_HXX
#include "xmlImage.hxx"
#endif
#ifndef RPT_XMLFILTER_HXX
#include "xmlfilter.hxx"
#endif
#ifndef _XMLOFF_XMLTOKEN_HXX
#include <xmloff/xmltoken.hxx>
#endif
#ifndef _XMLOFF_XMLNMSPE_HXX
#include <xmloff/xmlnmspe.hxx>
#endif
#ifndef _XMLOFF_NMSPMAP_HXX
#include <xmloff/nmspmap.hxx>
#endif
#ifndef RPT_XMLENUMS_HXX
#include "xmlEnums.hxx"
#endif
#ifndef RPT_XMLCOMPONENT_HXX
#include "xmlComponent.hxx"
#endif
#ifndef RPT_XMLREPORTELEMENT_HXX
#include "xmlReportElement.hxx"
#endif
#ifndef RPT_XMLCONTROLPROPERTY_HXX
#include "xmlControlProperty.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

namespace rptxml
{
	using namespace ::com::sun::star;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::xml::sax;
DBG_NAME( rpt_OXMLImage )

OXMLImage::OXMLImage( ORptFilter& rImport,
				sal_uInt16 nPrfx, const ::rtl::OUString& rLName,
				const Reference< XAttributeList > & _xAttrList
				,const Reference< XImageControl > & _xComponent 
                ,OXMLTable* _pContainer) :
	OXMLReportElementBase( rImport, nPrfx, rLName,_xComponent.get(),_pContainer)
{
    DBG_CTOR( rpt_OXMLImage,NULL);

	OSL_ENSURE(m_xComponent.is(),"Component is NULL!");
	const SvXMLNamespaceMap& rMap = m_rImport.GetNamespaceMap();
	const SvXMLTokenMap& rTokenMap = m_rImport.GetControlElemTokenMap();
    static const ::rtl::OUString s_sTRUE = ::xmloff::token::GetXMLToken(XML_TRUE);

	const sal_Int16 nLength = (_xAttrList.is()) ? _xAttrList->getLength() : 0;
	try
	{
		for(sal_Int16 i = 0; i < nLength; ++i)
		{
		 ::rtl::OUString sLocalName;
			const rtl::OUString sAttrName = _xAttrList->getNameByIndex( i );
			const sal_uInt16 nPrefix = rMap.GetKeyByAttrName( sAttrName,&sLocalName );
			const rtl::OUString sValue = _xAttrList->getValueByIndex( i );

			switch( rTokenMap.Get( nPrefix, sLocalName ) )
			{
				case XML_TOK_IMAGE_DATA:
					_xComponent->setImageURL(rImport.GetAbsoluteReference( sValue ));
					break;
                case XML_TOK_PRESERVE_IRI:
					_xComponent->setPreserveIRI(s_sTRUE == sValue);
					break;
                case XML_TOK_SCALE:
					_xComponent->setScaleImage(s_sTRUE == sValue);
					break;
                case XML_TOK_DATA_FORMULA: 
                    _xComponent->setDataField(ORptFilter::convertFormula(sValue));
					break;
                default:
                    break;
			}
		}
	}
	catch(Exception&)
	{
		OSL_ENSURE(0,"Exception catched while filling the image props");
	}
}
// -----------------------------------------------------------------------------

OXMLImage::~OXMLImage()
{

    DBG_DTOR( rpt_OXMLImage,NULL);
}
// -----------------------------------------------------------------------------

//----------------------------------------------------------------------------
} // namespace rptxml
// -----------------------------------------------------------------------------
