/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: TaskPaneService.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: rt $ $Date: 2007/04/03 16:21:00 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

#ifndef SD_FRAMEWORK_TASK_PANE_SERVICE_HXX
#define SD_FRAMEWORK_TASK_PANE_SERVICE_HXX

#include "MutexOwner.hxx"

#ifndef _COM_SUN_STAR_LANG_XINITIALIZATION_HPP_
#include <com/sun/star/lang/XInitialization.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_XCOMPONENTCONTEXT_HPP_
#include <com/sun/star/uno/XComponentContext.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XCONTROLLERMANAGER_HPP_
#include <com/sun/star/drawing/framework/XControllerManager.hpp>
#endif
#ifndef _COM_SUN_STAR_DRAWING_FRAMEWORK_XRESOURCECONTROLLER_HPP_
#include <com/sun/star/drawing/framework/XResourceController.hpp>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _CPPUHELPER_COMPBASE2_HXX_
#include <cppuhelper/compbase2.hxx>
#endif

#include <boost/scoped_ptr.hpp>

namespace {

typedef ::cppu::WeakComponentImplHelper2 <
    ::com::sun::star::lang::XInitialization,
    ::com::sun::star::drawing::framework::XResourceController
    > TaskPaneServiceInterfaceBase;

} // end of anonymous namespace.


namespace sd { class ViewShellBase; }

namespace sd { namespace framework {

/** This class represents the task pane view shell as drawing framework
    resource controller.  It gives access to the currently active task
    panel.
*/
class TaskPaneService
    : private sd::MutexOwner,
      public TaskPaneServiceInterfaceBase      
{
public:
    TaskPaneService (
        const ::com::sun::star::uno::Reference<com::sun::star::uno::XComponentContext>& rxContext);
    virtual ~TaskPaneService (void);
    
    virtual void SAL_CALL disposing (void);

    
    // XInitialization
    
    virtual void SAL_CALL initialize(
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Any>& aArguments)
        throw (::com::sun::star::uno::Exception, ::com::sun::star::uno::RuntimeException);


    // XResourceController

    virtual void SAL_CALL updateStart (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToDeactivate)
        throw (::com::sun::star::uno::RuntimeException);

    virtual void SAL_CALL updateEnd (
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxRequestedConfiguration,
        const ::com::sun::star::uno::Reference<
            ::com::sun::star::drawing::framework::XConfiguration>& rxCurrentConfiguration,
        const ::com::sun::star::uno::Sequence<com::sun::star::uno::Reference<
            com::sun::star::drawing::framework::XResourceId> >& rxResourcesToActivate)
        throw (::com::sun::star::uno::RuntimeException);

private:
    ViewShellBase* mpViewShellBase;

    void ThrowIfDisposed (void) const
        throw (::com::sun::star::lang::DisposedException);
};

} } // end of namespace sd::framework

#endif
