/*************************************************************************
 *
 *  OpenOffice.org - a multi-platform office productivity suite
 *
 *  $RCSfile: stormodifylistener.cxx,v $
 *
 *  $Revision: 1.5 $
 *
 *  last change: $Author: obo $ $Date: 2006/09/17 16:45:43 $
 *
 *  The Contents of this file are made available subject to
 *  the terms of GNU Lesser General Public License Version 2.1.
 *
 *
 *    GNU Lesser General Public License Version 2.1
 *    =============================================
 *    Copyright 2005 by Sun Microsystems, Inc.
 *    901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *    This library is free software; you can redistribute it and/or
 *    modify it under the terms of the GNU Lesser General Public
 *    License version 2.1, as published by the Free Software Foundation.
 *
 *    This library is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *    Lesser General Public License for more details.
 *
 *    You should have received a copy of the GNU Lesser General Public
 *    License along with this library; if not, write to the Free Software
 *    Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *    MA  02111-1307  USA
 *
 ************************************************************************/

// MARKER(update_precomp.py): autogen include statement, do not remove
#include "precompiled_sfx2.hxx"

#include "stormodifylistener.hxx"

using namespace ::com::sun::star;

OStorageModifyListen_Impl::OStorageModifyListen_Impl( SfxBaseModel& aModel )
: m_pModel( &aModel )
{}

OStorageModifyListen_Impl::~OStorageModifyListen_Impl()
{}

void OStorageModifyListen_Impl::OwnerIsDisposed()
{
	::osl::MutexGuard aGuard( m_aMutex );
	m_pModel = NULL;
}

void SAL_CALL OStorageModifyListen_Impl::modified( const ::com::sun::star::lang::EventObject& )
		throw ( ::com::sun::star::uno::RuntimeException )
{
	::osl::MutexGuard aGuard( m_aMutex );
	// StorageIsModified_Impl must not contain any locking!
	if ( m_pModel )
		m_pModel->StorageIsModified_Impl();
}

void SAL_CALL OStorageModifyListen_Impl::disposing( const lang::EventObject& )
		throw ( uno::RuntimeException )
{
	// not interesting 
}

