/*************************************************************************
 *
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 * 
 * Copyright 2008 by Sun Microsystems, Inc.
 *
 * OpenOffice.org - a multi-platform office productivity suite
 *
 * $RCSfile: helperminimaldepth3d.hxx,v $
 * $Revision: 1.1.2.1 $
 *
 * This file is part of OpenOffice.org.
 *
 * OpenOffice.org is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * OpenOffice.org is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details
 * (a copy is included in the LICENSE file that accompanied this code).
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with OpenOffice.org.  If not, see
 * <http://www.openoffice.org/license.html>
 * for a copy of the LGPLv3 License.
 *
 ************************************************************************/

#ifndef INCLUDED_SVX_HELPERMINIMALDEPTH_HXX
#define INCLUDED_SVX_HELPERMINIMALDEPTH_HXX

#include <sal/types.h>

//////////////////////////////////////////////////////////////////////////////
// predefines

class E3dCompoundObject;
class E3dScene;

//////////////////////////////////////////////////////////////////////////////
/** support extracting the minimal depth of a 3d object in it's scene

    @param rObject
    The 3D Object from which the minimal depth needs to be calculated. The scene
    is defined by the object already

    @return
    The minimal depth of this object in unified ViewCoordinates. This is the
    Z-Coordinate of one object point in the range of [0.0 .. 1.0]. ViewCoordinates
    means the transformations (esp. rotation) of the scene are taken into account

*/
// support extracting the minimal depth of a 3d object in it's scene

double getMinimalDepthInViewCoordinates(const E3dCompoundObject& rObject);

//////////////////////////////////////////////////////////////////////////////

#endif // INCLUDED_SVX_HELPERMINIMALDEPTH_HXX

// eof
