
/*
 * Copyright (C) 2002-2003 Stefan Holst
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: oxine.h 1414 2006-10-28 12:47:20Z mschwerin $
 *
 */

#ifndef HAVE_OXINE_H
#define HAVE_OXINE_H
#ifdef __cplusplus
extern "C" {
#endif

#include "filelist.h"
#include "odk.h"
#include "otk.h"
#include "playlist.h"
#include "menulist.h"
#include "weather.h"

typedef struct oxine_s oxine_t;

struct oxine_s {
    xine_t *xine;

    otk_t *otk;
    odk_t *odk;

    int otk_clear_job;
    int playback_menu_job;

#ifdef HAVE_DISC_POLLING
    /* Even if polling support was compiled in at build time some people may
     * choose to disable it at runtime. */
    bool use_polling;
    /* This is a list of removable discs that are currently present in the
     * system. This list is filled by the polling thread (see disc.c).*/
    filelist_t *removable_discs;
#endif

#ifdef HAVE_WEATHER
    /* This is the current weather data. It is updated by the weather thread
     * (see weather.c). */
    weather_t *weather;
    /* This mutex is necessary, as we have several threads updating a single
     * weather object. */
    pthread_mutex_t weather_mutex;
#endif

    /* This is TRUE whenever a GUI is visible. */
    bool user_interface_is_visible;
    /* This is TRUE whenever the playback controls are visible. */
    bool playback_controls_are_visible;
    /* This is TRUE whenever the stream parameter is visible. */
    bool stream_parameter_is_visible;

    /* This is the main playlist that is used for normal media files. This is
     * the playlist, that the user can edit. */
    playlist_t *rw_playlist;
    /* This playlist is used for DVD, VCD, DVB, V4L, VDR playback. It is also
     * used to add any files the user may specify on the command line. This
     * playlist can not be edited in any way. */
    playlist_t *ro_playlist;
    /* This is the current playlist. It can be one of the above. */
    playlist_t *current_playlist;

    /* This should point to the current menu. It is used by dialogs to know
     * where the cancel button should point to. */
    otk_cb_t backto_menu;
    /* This should point to the currently visible menu or to
     * hide_user_interface. It is used to repaint the current menu. */
    otk_cb_t current_menu;
    /* This should point to the menu where we are to go after playback ends.
     * It is not used if current_menu is not show_playback_menu_cb or
     * hide_user_interface. */
    otk_cb_t playback_ended_menu;

    /* The items of the main menu. */
    menulist_t *main_menu_items;

    /* This mutex is used so that only one thread at a time can download
     * anything. */
    pthread_mutex_t download_mutex;

    /* This struct stores the data used to show a message dialog. This is
     * necessary so we can show the same message dialog when a repaint event
     * occurs. I'd rather have defined this locally in gui_utils.c but we have
     * to initialize and free it somewhere. */
    struct {
        otk_cb_t ok_cb;
        void *ok_cb_data;
        otk_cb_t cancel_cb;
        void *cancel_cb_data;
        int type;
        char *background_mrl;
        char *msg;
    } current_dialog_data;

    /* This is the command that the user wants to be executed when shutting
     * down oxine. We want to execute this right before leaving main. */
    char *shutdown_command;
};

#ifdef __cplusplus
}
#endif
#endif /* HAVE_OXINE_H */
