
/*
 * Copyright (C) 2004-2005 Maximilian Schwerin
 *
 * This file is part of oxine a free media player.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *
 * $Id: playlist_m3u.h 1250 2006-10-06 07:52:11Z mschwerin $
 *
 */

#ifndef HAVE_PLAYLIST_M3U_H
#define HAVE_PLAYLIST_M3U_H
#ifdef __cplusplus
extern "C" {
#endif

#include "filelist.h"
#include "playlist.h"
#include "types.h"

char *trim_whitespace (char *str);

bool playlist_m3u_read (filelist_t * filelist);

bool playlist_m3u_save (playlist_t * playlist, const char *mrl);

bool playlist_m3u_load (playlist_t * playlist, const char *mrl);

#ifdef __cplusplus
}
#endif
#endif /* HAVE_PLAYLIST_M3U_H */
