/* places-glib: A GObject wrapper for the Mozilla Places API
 *
 * Copyright (C) 2009  Intel Corporation
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the
 * Free Software Foundation, Inc., 59 Temple Place - Suite 330,
 * Boston, MA 02111-1307, USA.
 */

#ifndef __PLACES_HISTORY_H__
#define __PLACES_HISTORY_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define PLACES_TYPE_HISTORY                                             \
  (places_history_get_type())
#define PLACES_HISTORY(obj)                                             \
  (G_TYPE_CHECK_INSTANCE_CAST ((obj),                                   \
                               PLACES_TYPE_HISTORY,                     \
                               PlacesHistory))
#define PLACES_HISTORY_CLASS(klass)                                     \
  (G_TYPE_CHECK_CLASS_CAST ((klass),                                    \
                            PLACES_TYPE_HISTORY,                        \
                            PlacesHistoryClass))
#define PLACES_IS_HISTORY(obj)                                          \
  (G_TYPE_CHECK_INSTANCE_TYPE ((obj),                                   \
                               PLACES_TYPE_HISTORY))
#define PLACES_IS_HISTORY_CLASS(klass)                                  \
  (G_TYPE_CHECK_CLASS_TYPE ((klass),                                    \
                            PLACES_TYPE_HISTORY))
#define PLACES_HISTORY_GET_CLASS(obj)                                   \
  (G_TYPE_INSTANCE_GET_CLASS ((obj),                                    \
                              PLACES_TYPE_HISTORY,                      \
                              PlacesHistoryClass))

typedef struct _PlacesHistory         PlacesHistory;
typedef struct _PlacesHistoryClass    PlacesHistoryClass;
typedef struct _PlacesHistoryPrivate  PlacesHistoryPrivate;

struct _PlacesHistoryClass
{
  GObjectClass parent_class;

  void (* ac_result_received) (PlacesHistory *history,
                               guint32 search_id,
                               const gchar *value,
                               const gchar *comment);
};

struct _PlacesHistory
{
  GObject parent;

  PlacesHistoryPrivate *priv;
};

typedef void (* PlacesHistoryFaviconCallback) (PlacesHistory *history,
                                               const gchar *mime_type,
                                               const guint8 *data,
                                               guint data_len,
                                               const GError *error,
                                               gpointer user_data);

GType places_history_get_type (void) G_GNUC_CONST;

PlacesHistory *places_history_new (void);

gboolean places_history_add_uri (PlacesHistory *self,
                                 const gchar *uri,
                                 GError **error);

gboolean places_history_set_page_title (PlacesHistory *self,
                                        const gchar *uri,
                                        const gchar *title,
                                        GError **error);

gboolean places_history_start_ac_search (PlacesHistory *self,
                                         const gchar *search_str,
                                         guint32 *search_id,
                                         GError **error);

gboolean places_history_stop_ac_search (PlacesHistory *self,
                                        guint32 search_id,
                                        GError **error);

gboolean places_history_set_favicon_url (PlacesHistory *self,
                                         const gchar *page_uri,
                                         const gchar *favicon_uri,
                                         GError **error);

gboolean places_history_set_default_favicon_url (PlacesHistory *self,
                                                 const gchar *page_uri,
                                                 GError **error);

guint places_history_get_favicon (PlacesHistory *self,
                                  const gchar *page_uri,
                                  gboolean download,
                                  PlacesHistoryFaviconCallback callback,
                                  gpointer user_data,
                                  GDestroyNotify user_data_notify);

void places_history_cancel (PlacesHistory *self,
                            guint id);

G_END_DECLS

#endif /* __PLACES_HISTORY_H__ */
