"""
TODO:
    * maybe move initialisation of libxml2 parser to utils
"""

import utils
import libxml2
import urlparse
from bugbase import LPBugInfo
from buglistbase import LPBugList, LPBugPage
from lphelper import user, unicode_for_libxml2

#deactivate error messages from the validation [libxml2.htmlParseDoc]
def noerr(ctx, str):
    pass
libxml2.registerErrorHandler(noerr, None)


class BugInfo(LPBugInfo):
    # TODO: use same attribute names like Bug.Bug
    def __init__(self, nr, url, status, importance, summary, package=None, all_tasks=False):
        url = utils.valid_lp_url(url,utils.BUG)
        assert url, "Invalid launchpad url %s" %url
        LPBugInfo.__init__(self, nr, url, status, importance, summary, package, all_tasks)
        

class BugPage(LPBugPage):
    """
    grab content of a single bug-table    
    """
    @staticmethod
    def find_parse_function(connection, url, all_tasks):
        lp_content = connection.get(url)
        xmldoc = libxml2.htmlParseDoc(unicode_for_libxml2(lp_content.text), "UTF-8")
        u = urlparse.urlsplit(url)
        if "+milestone" in u[2]:
            result = BugPage.parse_html_milestone_bugpage(xmldoc, all_tasks, url)
        else:
            result = BugPage.parse_html_bugpage(xmldoc, all_tasks, url)
        return result
        
    @staticmethod
    def parse_html_bugpage(xmldoc, all_tasks, url):
        def _parse():
            if xmldoc.xpathEval('//div/p[contains(.,"There are currently no open bugs.")]') or xmldoc.xpathEval('//div/p[contains(.,"No results for search")]'):
                raise StopIteration
                
            # count number of columns
            # Bug-Pages have seven columns: icon|nr|summary(url)|icon(milestone|branch|blueprint)|package|importance|status
            # personal Bug-Pages have six columns: icon|nr|summary(url)|package|importance|status
            # TODO: look for more simple XPath-statements
            col = int(xmldoc.xpathEval('count(//table[@id="buglisting"]//thead//tr//th[not(@*)])'))
            for span in xmldoc.xpathEval('//table[@id="buglisting"]//thead//tr//@colspan'):
                col += int(span.content)

            assert col == 6 or col == 7, "Parsing of this page (%s) is not \
    supported by python-launchpad-bugs" %url
            bug_table_rows = xmldoc.xpathEval('//table[@id="buglisting"]//tbody//tr')
            for row in bug_table_rows:
                out = []
                for i in xrange(2,col+1):
                    if i == 3:
                        expr = 'td[' + str(i) + ']//a'
                    else:
                        expr = 'td[' + str(i) + ']/text()'
                    res = row.xpathEval(expr)
                    assert res, "Wrong XPath-Expression in BugPage (%s)" %url
                    if i == 3:
                        out.append(res[0].prop("href"))
                    out.append(res[0].content)
                #drop icon td
                out.pop(3)
                # package is optional, move package to the end of the list
                if len(out) == 6:
                    out.append(out.pop(3))
                else:
                    out.append(None)
                yield BugInfo(out[0], out[1], out[4],out[3], utils.sanitize_html(out[2]),
                                    out[5], all_tasks)

        next = xmldoc.xpathEval('//div[@class="lesser"]//a[@rel="next"]//@href')
        if next:
            return _parse(), utils.sanitize_html(next[0].content)
        return _parse(), False
        
    @staticmethod
    def parse_html_milestone_bugpage(xmldoc, all_tasks, url):
        def _parse():
            bug_table_rows = xmldoc.xpathEval('//table[@id="milestone_bugtasks"]//tbody//tr')
            for row in bug_table_rows:
                x = row.xpathEval('td[1]//span/img')
                assert x, "Wrong XPath-Expression in BugPage (%s)" %url
                importance = x[0].prop("alt").strip("()").title()
                x = row.xpathEval('td[2]')
                assert x, "Wrong XPath-Expression in BugPage (%s)" %url
                nr = x[0].content
                x = row.xpathEval('td[3]/a')
                assert x, "Wrong XPath-Expression in BugPage (%s)" %url
                url = x[0].prop("href")
                summary = x[0].content
                x = row.xpathEval('td[5]//a')
                if x:
                    usr = user.parse_html_user(x[0])
                else:
                    usr = user(None)
                x = row.xpathEval('td[6]/span[2]')
                assert x, "Wrong XPath-Expression in BugPage (%s)" %url
                status = x[0].content
                x = BugInfo(nr, url, status, importance, summary, None, all_tasks)
                x.assignee = usr
                yield x
        return _parse(), False
        

class BugList(LPBugList):
    """
    returns a SET of LPBugInfo objects
    searches baseurl and its following pages
    """
    def __init__(self, baseurl, connection=None, filter=None, length=True,
                    all_tasks=False, start_bugs=[], helper_bugpage=None):
        LPBugList.__init__(self, baseurl, connection, filter, length,
                                all_tasks, start_bugs, BugPage)
    

        
#some test-cases
if __name__ == '__main__':
    from http_connection import HTTPConnection
    
    con = HTTPConnection()
    
    a, n = BugPage.find_parse_function(con, "https://bugs.edge.launchpad.net/ubuntu/+source/hal", False)
    print "next:", n
    x = set(a)
    print x
    print vars(x.pop())

    a, n = BugPage.find_parse_function(con, "https://bugs.edge.launchpad.net/~thekorn", False)
    print "next:", n
    x = set(a)
    print x
    print vars(x.pop())

    a, n = BugPage.find_parse_function(con, "https://bugs.edge.launchpad.net/ubuntu/+milestone/ubuntu-8.04-beta", False)
    print "next:", n
    x = set(a)
    print x
    print vars(x.pop())
