# TODO: convert into unittest

import launchpadbugs.connector as Connector

BugList = Connector.ConnectBugList()

bl = BugList("https://bugs.launchpad.net/bughelper/+bugs")

print bl.bugs

print ">>> minbug 100000"
BugList.set_filter(minbug=100000)

print bl.filter().bugs

print ">>> filter bugs 84723, 110937, 109628, 123933"
BugList.set_filter(filterbug="84723, 110937, 109628, 123933")

print bl.filter().bugs


print ">>> filter bugs 84723, 110937, 109628, 123933 after resetting the filter"
BugList.reset_filter()
BugList.set_filter(filterbug="84723, 110937, 109628, 123933")

print bl.filter().bugs

print "======== opturl ========="
print "tag == 'display':",
BugList.reset_filter()
BugList.set_filter(tag="display")
print BugList.urlopt

print "status == 'New':",
BugList.reset_filter()
BugList.set_filter(status="New")
print BugList.urlopt

print "importance == 'High':",
BugList.reset_filter()
BugList.set_filter(importance="High")
print BugList.urlopt

print "duplicates == True:",
BugList.reset_filter()
BugList.set_filter(duplicates=True)
print BugList.urlopt

print "closed_bugs == True:",
BugList.reset_filter()
BugList.set_filter(closed_bugs=True)
print BugList.urlopt

print "added urlopt to given url:"
BugList.reset_filter()
BugList.set_filter(importance="High", url="https://bugs.launchpad.net/bughelper/+bugs")
print BugList.modified_url

print ">> run custom filter function:"
BugList.reset_filter()

def RFE_filter(bugs):
    result = set()
    for b in bugs:
        if b.summary.startswith("RFE"):
            result.add(b)
    return result
            

for b in bl.filter(func=[RFE_filter]).bugs:
    print "%s (%s)" %(b.summary, b.bugnumber)
