"""
Example using of Buglist
========================

TODO:
* Use LauchpadConnector class
"""

import launchpadbugs.connector as Connector

BugList = Connector.ConnectBugList(method="text")

print ">>> Getting a list of bugs"
l = BugList("https://bugs.launchpad.net/ubuntu/+source/bughelper/+bugs")
print
print "str:", l
print "repr:", repr(l)
print
for i in l.bugs:
    print i.bugnumber,
    print i.url,
    print i.summary,
    print i.importance,
    print i.status,
    print i.sourcepackage

print "\n>>> Adding some (upstream) bugs to the set"
l += BugList("https://bugs.launchpad.net/bughelper/+bugs")
print l.bugs

print "\n>>> Setting a filter and filter the set of bugs"
BugList.set_filter(minbug=100000, filterbug="117701,109628", status="New")
l = l.filter()
print l.bugs

print "\n>>> add LP urloptions to an url"
a = BugList("https://launchpad.net/ubuntu/+source/apport/+bugs?%s" %BugList.urlopt)
print a.bugs

print "\n>>> Sorting the list of bugs"
print l.sort("nr")

print "\n>>> Multipage Buglist"
try:
    a = BugList("https://bugs.launchpad.net/ubuntu/+source/hal")
    print "There a %i bugs in ubuntu/hal" %len(a.bugs)
except BugList.Error.LPUrlError, e:
    print e

print "\n>>> Raising LPUrlError for invalid urls"
try:
    a = BugList("https://bugs.launchpad.net/ubuntu/+source/firefokkksss/+bugs")
    print len(a.bugs)
except BugList.Error.LPUrlError, e:
    print e

