""" Testing Connector - run this test with 'python -m testing.test_Connector' """

import unittest
import launchpadbugs.connector as Connector

class _ConnectorTest(unittest.TestCase):
    
    def test_LaunchpadConnector(self):
        """ LaunchpadConnector should raise 'NotImplementedError' for non exsisting methodes """
        
        self.assertRaises(NotImplementedError, Connector.LaunchpadConnector, "Bug", "Test")
        
        
    def test_ConnectBug(self):
        """ ConnectBug should raise 'NotImplementedError' for non exsisting methodes """
        
        self.assertRaises(NotImplementedError, Connector.ConnectBug, "Test")
        
        
    def test_ConnectBug(self):
        """ ConnectBug: default authentication value should be 'None' """

        b = Connector.ConnectBug()
        self.assertEqual(b.authentication, None)
        
        
    def test_ConnectBugList(self):
        """ ConnectBugList should raise 'NotImplementedError' for non exsisting methodes """
        
        self.assertRaises(NotImplementedError, Connector.ConnectBugList, "Test")
        
        
    def test_ConnectBugList(self):
        """ ConnectBugList: default authentication value should be 'None' """
        
        bl = Connector.ConnectBugList()
        self.assertEqual(bl.authentication, None)

if __name__ == '__main__':
    suite = unittest.TestLoader().loadTestsFromTestCase(_ConnectorTest)
    unittest.TextTestRunner(verbosity=2).run(suite)
