""" Testing HTTPConnection - run this test with 'python -m testing.test_HTTPConnection' """

import unittest
import launchpadbugs.http_connection as HTTPConnection
import launchpadbugs.bughelper_error as Error

class _HTTPConnectorTest(unittest.TestCase):
    
    def test__result(self):
        self.assertRaises(AssertionError, HTTPConnection._result,)
        
        
    def test_HTTPConnection(self):
        con = HTTPConnection.HTTPConnection()
        self.assertEqual(con.get_auth(), None)
        
        
    def test_set_cookie_handler(self):
        pass
        
        
    def test_get(self):
        con = HTTPConnection.HTTPConnection()
        self.assertRaises(Error.LPUrlError, con._safe_urlopen,
            "https://bugs.launchpad.net/buglog-data/+bug/120593/+edit", None, False)
        self.assertRaises(Error.LPUrlError, con._safe_urlopen,
            "http://www.someurlwhichdoesnotexsist.com", None, False)
        self.assert_(con._safe_urlopen("http://www.google.com", None, False))
        
        
    def test_post(self):
        pass

if __name__ == '__main__':
    suite = unittest.TestLoader().loadTestsFromTestCase(_HTTPConnectorTest)
    unittest.TextTestRunner(verbosity=2).run(suite)
