#!/usr/bin/python

import os
import sys, os.path
sys.path.insert(0, os.path.realpath(os.path.join(os.path.dirname(__file__), "..")))

import unittest
from lpltk.LaunchpadService import LaunchpadService
from lpltk.utils            import o2str

class TestTags(unittest.TestCase):

    # setUp
    #
    def setUp(self):
        self.configuration = {}
        self.configuration['launchpad_services_root'] = 'staging'

    # tearDown
    #
    def tearDown(self):
        ls    = LaunchpadService(self.configuration)
        bug   = ls.get_bug(3)
        tags = []
        for tag in bug.tags:
            tags.append(tag)

        for tag in tags:
            bug.tags.remove(o2str(tag))

        bug.tags.append('feature')
        
    # test__init__
    #
    def test__init__(self):
        # Tags object creation
        #
        try:
            ls  = LaunchpadService(self.configuration)
            bug = ls.get_bug(3)
            tags = bug.tags
        finally:
            bug = None
            ls  = None

    # test__contains__
    #
    def test__contains__(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            self.assertTrue('feature' in bug.tags)
            self.assertTrue('foo' not in bug.tags)
        finally:
            bug = None
            ls  = None

    # test__setitem__
    #
    def test__setitem__(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            bug.tags[0] = 'setitem'
            self.assertTrue('setitem' == bug.tags[0])
            bug.tags[0] = 'feature'
            self.assertTrue('feature' == bug.tags[0])
        finally:
            bug = None
            ls  = None

    # test__getitem__
    #
    def test__getitem__(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            self.assertTrue('feature' == bug.tags[0])
        finally:
            bug = None
            ls  = None

    # test__iter__
    #
    def test__iter__(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)

            ct = 0
            for tag in bug.tags:
                ct += 1
                self.assertTrue('feature' == bug.tags[0])
            self.assertTrue(ct == 1)

        finally:
            bug = None
            ls  = None

    # test_len
    #
    def test_len(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            self.assertTrue(len(bug.tags) == 1)
        finally:
            bug = None
            ls  = None

    # test_append
    #
    def test_append(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            bug.tags.append('append')
            self.assertTrue(len(bug.tags) == 2)
            self.assertTrue('append' in bug.tags)
            self.assertTrue('append' == bug.tags[0])
        finally:
            bug = None
            ls  = None

    # test_extend
    #
    def test_extend(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            tags_ct = len(bug.tags) # We don't know which order the tests will be run
            bug.tags.extend(['extend', 'extend2'])
            self.assertTrue(len(bug.tags) == (tags_ct + 2))
            self.assertTrue('extend' in bug.tags)
            self.assertTrue('extend2' in bug.tags)
        finally:
            bug = None
            ls  = None

    # test_remove
    #
    def test_remove(self):
        try:
            ls    = LaunchpadService(self.configuration)
            bug   = ls.get_bug(3)
            tags_ct = len(bug.tags) # We don't know which order the tests will be run
            bug.tags.extend(['remove1', 'remove2'])
            self.assertTrue(len(bug.tags) == (tags_ct + 2))
            self.assertTrue('remove1' in bug.tags)
            self.assertTrue('remove2' in bug.tags)
            bug.tags.remove('remove1')
            bug.tags.remove('remove2')
        finally:
            bug = None
            ls  = None

if __name__ == '__main__':
    unittest.main()

# vi:set ts=4 sw=4 expandtab:
