#!/usr/bin/python

import sys
import lightmediascanner


try:
    category = sys.argv[1]
except IndexError:
    category = None


def print_info(info):
    print "parser: ", info.path
    print "\tname.......:", info.name
    print "\tcategories.:"
    for v in info.categories:
        print "\t\t", v
    print "\tdescription:", info.description
    print "\tversion....:", info.version
    print "\tauthors....:"
    for v in info.authors:
        print "\t\t", v
    print "\turi........:", info.uri


if category:
    for info in lightmediascanner.parsers_list_by_category(category):
        print_info(info)
else:
    for p in lightmediascanner.parsers_list():
        info = lightmediascanner.parser_info(p)
        if info:
            print_info(info)
        else:
            print "parser: ", p
