/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"

#if ENABLE(SVG)

#include "JSSVGEllipseElement.h"

#include "CSSMutableStyleDeclaration.h"
#include "CSSStyleDeclaration.h"
#include "CSSValue.h"
#include "JSCSSStyleDeclaration.h"
#include "JSCSSValue.h"
#include "JSSVGAnimatedBoolean.h"
#include "JSSVGAnimatedLength.h"
#include "JSSVGAnimatedString.h"
#include "JSSVGAnimatedTransformList.h"
#include "JSSVGElement.h"
#include "JSSVGMatrix.h"
#include "JSSVGRect.h"
#include "JSSVGStringList.h"
#include "KURL.h"
#include "SVGElement.h"
#include "SVGEllipseElement.h"
#include "SVGStringList.h"
#include <runtime/Error.h>
#include <runtime/JSString.h>
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSSVGEllipseElement);

/* Hash table */

static const HashTableValue JSSVGEllipseElementTableValues[16] =
{
    { "cx", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementCx, (intptr_t)0 },
    { "cy", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementCy, (intptr_t)0 },
    { "rx", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementRx, (intptr_t)0 },
    { "ry", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementRy, (intptr_t)0 },
    { "requiredFeatures", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementRequiredFeatures, (intptr_t)0 },
    { "requiredExtensions", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementRequiredExtensions, (intptr_t)0 },
    { "systemLanguage", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementSystemLanguage, (intptr_t)0 },
    { "xmllang", DontDelete, (intptr_t)jsSVGEllipseElementXmllang, (intptr_t)setJSSVGEllipseElementXmllang },
    { "xmlspace", DontDelete, (intptr_t)jsSVGEllipseElementXmlspace, (intptr_t)setJSSVGEllipseElementXmlspace },
    { "externalResourcesRequired", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementExternalResourcesRequired, (intptr_t)0 },
    { "className", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementClassName, (intptr_t)0 },
    { "style", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementStyle, (intptr_t)0 },
    { "transform", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementTransform, (intptr_t)0 },
    { "nearestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementNearestViewportElement, (intptr_t)0 },
    { "farthestViewportElement", DontDelete|ReadOnly, (intptr_t)jsSVGEllipseElementFarthestViewportElement, (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGEllipseElementTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 127, JSSVGEllipseElementTableValues, 0 };
#else
    { 35, 31, JSSVGEllipseElementTableValues, 0 };
#endif

/* Hash table for prototype */

static const HashTableValue JSSVGEllipseElementPrototypeTableValues[7] =
{
    { "hasExtension", DontDelete|Function, (intptr_t)jsSVGEllipseElementPrototypeFunctionHasExtension, (intptr_t)1 },
    { "getPresentationAttribute", DontDelete|Function, (intptr_t)jsSVGEllipseElementPrototypeFunctionGetPresentationAttribute, (intptr_t)1 },
    { "getBBox", DontDelete|Function, (intptr_t)jsSVGEllipseElementPrototypeFunctionGetBBox, (intptr_t)0 },
    { "getCTM", DontDelete|Function, (intptr_t)jsSVGEllipseElementPrototypeFunctionGetCTM, (intptr_t)0 },
    { "getScreenCTM", DontDelete|Function, (intptr_t)jsSVGEllipseElementPrototypeFunctionGetScreenCTM, (intptr_t)0 },
    { "getTransformToElement", DontDelete|Function, (intptr_t)jsSVGEllipseElementPrototypeFunctionGetTransformToElement, (intptr_t)1 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSSVGEllipseElementPrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 2047, JSSVGEllipseElementPrototypeTableValues, 0 };
#else
    { 17, 15, JSSVGEllipseElementPrototypeTableValues, 0 };
#endif

const ClassInfo JSSVGEllipseElementPrototype::s_info = { "SVGEllipseElementPrototype", 0, &JSSVGEllipseElementPrototypeTable, 0 };

JSObject* JSSVGEllipseElementPrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSSVGEllipseElement>(exec, globalObject);
}

bool JSSVGEllipseElementPrototype::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticFunctionSlot<JSObject>(exec, &JSSVGEllipseElementPrototypeTable, this, propertyName, slot);
}

bool JSSVGEllipseElementPrototype::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticFunctionDescriptor<JSObject>(exec, &JSSVGEllipseElementPrototypeTable, this, propertyName, descriptor);
}

const ClassInfo JSSVGEllipseElement::s_info = { "SVGEllipseElement", &JSSVGElement::s_info, &JSSVGEllipseElementTable, 0 };

JSSVGEllipseElement::JSSVGEllipseElement(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<SVGEllipseElement> impl)
    : JSSVGElement(structure, globalObject, impl)
{
}

JSObject* JSSVGEllipseElement::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSSVGEllipseElementPrototype(JSSVGEllipseElementPrototype::createStructure(JSSVGElementPrototype::self(exec, globalObject)));
}

bool JSSVGEllipseElement::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSSVGEllipseElement, Base>(exec, &JSSVGEllipseElementTable, this, propertyName, slot);
}

bool JSSVGEllipseElement::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSSVGEllipseElement, Base>(exec, &JSSVGEllipseElementTable, this, propertyName, descriptor);
}

JSValue jsSVGEllipseElementCx(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->cxAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGEllipseElementCy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->cyAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGEllipseElementRx(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->rxAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGEllipseElementRy(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedLength> obj = imp->ryAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGEllipseElementRequiredFeatures(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredFeatures()), imp);
}

JSValue jsSVGEllipseElementRequiredExtensions(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->requiredExtensions()), imp);
}

JSValue jsSVGEllipseElementSystemLanguage(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->systemLanguage()), imp);
}

JSValue jsSVGEllipseElementXmllang(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return jsString(exec, imp->xmllang());
}

JSValue jsSVGEllipseElementXmlspace(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return jsString(exec, imp->xmlspace());
}

JSValue jsSVGEllipseElementExternalResourcesRequired(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedBoolean> obj = imp->externalResourcesRequiredAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGEllipseElementClassName(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedString> obj = imp->classNameAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGEllipseElementStyle(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->style()));
}

JSValue jsSVGEllipseElementTransform(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    RefPtr<SVGAnimatedTransformList> obj = imp->transformAnimated();
    return toJS(exec, castedThis->globalObject(), obj.get(), imp);
}

JSValue jsSVGEllipseElementNearestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->nearestViewportElement()));
}

JSValue jsSVGEllipseElementFarthestViewportElement(ExecState* exec, const Identifier&, const PropertySlot& slot)
{
    JSSVGEllipseElement* castedThis = static_cast<JSSVGEllipseElement*>(asObject(slot.slotBase()));
    UNUSED_PARAM(exec);
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThis->impl());
    return toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->farthestViewportElement()));
}

void JSSVGEllipseElement::put(ExecState* exec, const Identifier& propertyName, JSValue value, PutPropertySlot& slot)
{
    lookupPut<JSSVGEllipseElement, Base>(exec, propertyName, value, &JSSVGEllipseElementTable, this, slot);
}

void setJSSVGEllipseElementXmllang(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(static_cast<JSSVGEllipseElement*>(thisObject)->impl());
    imp->setXmllang(value.toString(exec));
}

void setJSSVGEllipseElementXmlspace(ExecState* exec, JSObject* thisObject, JSValue value)
{
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(static_cast<JSSVGEllipseElement*>(thisObject)->impl());
    imp->setXmlspace(value.toString(exec));
}

JSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionHasExtension(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwError(exec, TypeError);
    JSSVGEllipseElement* castedThisObj = static_cast<JSSVGEllipseElement*>(asObject(thisValue));
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThisObj->impl());
    const UString& extension = args.at(0).toString(exec);


    JSC::JSValue result = jsBoolean(imp->hasExtension(extension));
    return result;
}

JSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetPresentationAttribute(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwError(exec, TypeError);
    JSSVGEllipseElement* castedThisObj = static_cast<JSSVGEllipseElement*>(asObject(thisValue));
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThisObj->impl());
    const UString& name = args.at(0).toString(exec);


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), WTF::getPtr(imp->getPresentationAttribute(name)));
    return result;
}

JSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetBBox(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwError(exec, TypeError);
    JSSVGEllipseElement* castedThisObj = static_cast<JSSVGEllipseElement*>(asObject(thisValue));
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<FloatRect>::create(imp->getBBox()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwError(exec, TypeError);
    JSSVGEllipseElement* castedThisObj = static_cast<JSSVGEllipseElement*>(asObject(thisValue));
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetScreenCTM(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwError(exec, TypeError);
    JSSVGEllipseElement* castedThisObj = static_cast<JSSVGEllipseElement*>(asObject(thisValue));
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThisObj->impl());


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getScreenCTM()).get(), imp);
    return result;
}

JSValue JSC_HOST_CALL jsSVGEllipseElementPrototypeFunctionGetTransformToElement(ExecState* exec, JSObject*, JSValue thisValue, const ArgList& args)
{
    UNUSED_PARAM(args);
    if (!thisValue.inherits(&JSSVGEllipseElement::s_info))
        return throwError(exec, TypeError);
    JSSVGEllipseElement* castedThisObj = static_cast<JSSVGEllipseElement*>(asObject(thisValue));
    SVGEllipseElement* imp = static_cast<SVGEllipseElement*>(castedThisObj->impl());
    ExceptionCode ec = 0;
    SVGElement* element = toSVGElement(args.at(0));


    JSC::JSValue result = toJS(exec, castedThisObj->globalObject(), JSSVGStaticPODTypeWrapper<TransformationMatrix>::create(imp->getTransformToElement(element, ec)).get(), imp);
    setDOMException(exec, ec);
    return result;
}


}

#endif // ENABLE(SVG)
