/*
    This file is part of the WebKit open source project.
    This file has been generated by generate-bindings.pl. DO NOT MODIFY!

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to
    the Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor,
    Boston, MA 02110-1301, USA.
*/

#include "config.h"
#include "JSCSSImportRule.h"

#include "CSSImportRule.h"
#include "CSSStyleSheet.h"
#include "JSCSSStyleSheet.h"
#include "JSMediaList.h"
#include "KURL.h"
#include "MediaList.h"
#include <wtf/GetPtr.h>

using namespace JSC;

namespace WebCore {

ASSERT_CLASS_FITS_IN_CELL(JSCSSImportRule);

/* Hash table */

static const HashTableValue JSCSSImportRuleTableValues[5] =
{
    { "href", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleHref), (intptr_t)0 },
    { "media", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleMedia), (intptr_t)0 },
    { "styleSheet", DontDelete|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleStyleSheet), (intptr_t)0 },
    { "constructor", DontEnum|ReadOnly, (intptr_t)static_cast<PropertySlot::GetValueFunc>(jsCSSImportRuleConstructor), (intptr_t)0 },
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSImportRuleTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 7, JSCSSImportRuleTableValues, 0 };
#else
    { 8, 7, JSCSSImportRuleTableValues, 0 };
#endif

/* Hash table for constructor */

static const HashTableValue JSCSSImportRuleConstructorTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSImportRuleConstructorTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSImportRuleConstructorTableValues, 0 };
#else
    { 1, 0, JSCSSImportRuleConstructorTableValues, 0 };
#endif

class JSCSSImportRuleConstructor : public DOMConstructorObject {
public:
    JSCSSImportRuleConstructor(ExecState* exec, JSDOMGlobalObject* globalObject)
        : DOMConstructorObject(JSCSSImportRuleConstructor::createStructure(globalObject->objectPrototype()), globalObject)
    {
        putDirect(exec->propertyNames().prototype, JSCSSImportRulePrototype::self(exec, globalObject), None);
    }
    virtual bool getOwnPropertySlot(ExecState*, const Identifier&, PropertySlot&);
    virtual bool getOwnPropertyDescriptor(ExecState*, const Identifier&, PropertyDescriptor&);
    virtual const ClassInfo* classInfo() const { return &s_info; }
    static const ClassInfo s_info;

    static PassRefPtr<Structure> createStructure(JSValue proto) 
    { 
        return Structure::create(proto, TypeInfo(ObjectType, StructureFlags), AnonymousSlotCount); 
    }
    
protected:
    static const unsigned StructureFlags = OverridesGetOwnPropertySlot | ImplementsHasInstance | DOMConstructorObject::StructureFlags;
};

const ClassInfo JSCSSImportRuleConstructor::s_info = { "CSSImportRuleConstructor", 0, &JSCSSImportRuleConstructorTable, 0 };

bool JSCSSImportRuleConstructor::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSImportRuleConstructor, DOMObject>(exec, &JSCSSImportRuleConstructorTable, this, propertyName, slot);
}

bool JSCSSImportRuleConstructor::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSImportRuleConstructor, DOMObject>(exec, &JSCSSImportRuleConstructorTable, this, propertyName, descriptor);
}

/* Hash table for prototype */

static const HashTableValue JSCSSImportRulePrototypeTableValues[1] =
{
    { 0, 0, 0, 0 }
};

static JSC_CONST_HASHTABLE HashTable JSCSSImportRulePrototypeTable =
#if ENABLE(PERFECT_HASH_SIZE)
    { 0, JSCSSImportRulePrototypeTableValues, 0 };
#else
    { 1, 0, JSCSSImportRulePrototypeTableValues, 0 };
#endif

const ClassInfo JSCSSImportRulePrototype::s_info = { "CSSImportRulePrototype", 0, &JSCSSImportRulePrototypeTable, 0 };

JSObject* JSCSSImportRulePrototype::self(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMPrototype<JSCSSImportRule>(exec, globalObject);
}

const ClassInfo JSCSSImportRule::s_info = { "CSSImportRule", &JSCSSRule::s_info, &JSCSSImportRuleTable, 0 };

JSCSSImportRule::JSCSSImportRule(NonNullPassRefPtr<Structure> structure, JSDOMGlobalObject* globalObject, PassRefPtr<CSSImportRule> impl)
    : JSCSSRule(structure, globalObject, impl)
{
}

JSObject* JSCSSImportRule::createPrototype(ExecState* exec, JSGlobalObject* globalObject)
{
    return new (exec) JSCSSImportRulePrototype(JSCSSImportRulePrototype::createStructure(JSCSSRulePrototype::self(exec, globalObject)));
}

bool JSCSSImportRule::getOwnPropertySlot(ExecState* exec, const Identifier& propertyName, PropertySlot& slot)
{
    return getStaticValueSlot<JSCSSImportRule, Base>(exec, &JSCSSImportRuleTable, this, propertyName, slot);
}

bool JSCSSImportRule::getOwnPropertyDescriptor(ExecState* exec, const Identifier& propertyName, PropertyDescriptor& descriptor)
{
    return getStaticValueDescriptor<JSCSSImportRule, Base>(exec, &JSCSSImportRuleTable, this, propertyName, descriptor);
}

JSValue jsCSSImportRuleHref(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSImportRule* castedThis = static_cast<JSCSSImportRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSImportRule* imp = static_cast<CSSImportRule*>(castedThis->impl());
    JSValue result = jsStringOrNull(exec, imp->href());
    return result;
}

JSValue jsCSSImportRuleMedia(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSImportRule* castedThis = static_cast<JSCSSImportRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSImportRule* imp = static_cast<CSSImportRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->media()));
    return result;
}

JSValue jsCSSImportRuleStyleSheet(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSImportRule* castedThis = static_cast<JSCSSImportRule*>(asObject(slotBase));
    UNUSED_PARAM(exec);
    CSSImportRule* imp = static_cast<CSSImportRule*>(castedThis->impl());
    JSValue result = toJS(exec, castedThis->globalObject(), WTF::getPtr(imp->styleSheet()));
    return result;
}

JSValue jsCSSImportRuleConstructor(ExecState* exec, JSValue slotBase, const Identifier&)
{
    JSCSSImportRule* domObject = static_cast<JSCSSImportRule*>(asObject(slotBase));
    return JSCSSImportRule::getConstructor(exec, domObject->globalObject());
}
JSValue JSCSSImportRule::getConstructor(ExecState* exec, JSGlobalObject* globalObject)
{
    return getDOMConstructor<JSCSSImportRuleConstructor>(exec, static_cast<JSDOMGlobalObject*>(globalObject));
}


}
