/****************************************************************************
**
** Copyright (C) 2009 Nokia Corporation and/or its subsidiary(-ies).
** All rights reserved.
** Contact: Nokia Corporation (qt-info@nokia.com)
**
** This file is part of the Qt Mobility Components.
**
** $QT_BEGIN_LICENSE:LGPL$
** GNU Lesser General Public License Usage
** This file may be used under the terms of the GNU Lesser General Public
** License version 2.1 as published by the Free Software Foundation and
** appearing in the file LICENSE.LGPL included in the packaging of this
** file. Please review the following information to ensure the GNU Lesser
** General Public License version 2.1 requirements will be met:
** http://www.gnu.org/licenses/old-licenses/lgpl-2.1.html.
**
** In addition, as a special exception, Nokia gives you certain additional
** rights. These rights are described in the Nokia Qt LGPL Exception
** version 1.1, included in the file LGPL_EXCEPTION.txt in this package.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU General
** Public License version 3.0 as published by the Free Software Foundation
** and appearing in the file LICENSE.GPL included in the packaging of this
** file. Please review the following information to ensure the GNU General
** Public License version 3.0 requirements will be met:
** http://www.gnu.org/copyleft/gpl.html.
**
** Other Usage
** Alternatively, this file may be used in accordance with the terms and
** conditions contained in a signed written agreement between you and Nokia.
**
**
**
**
**
** $QT_END_LICENSE$
**
****************************************************************************/

#ifndef QORGANIZERTODOPROGRESS_H
#define QORGANIZERTODOPROGRESS_H

#include <QString>

#include "qtorganizerglobal.h"
#include "qorganizeritemdetail.h"
#include "qorganizeritem.h"

QTM_BEGIN_NAMESPACE

/* Leaf class */
class Q_ORGANIZER_EXPORT QOrganizerTodoProgress : public QOrganizerItemDetail
{
public:
#ifdef Q_QDOC
    static const QLatin1Constant DefinitionName;
    static const QLatin1Constant FieldFinishedDateTime;
    static const QLatin1Constant FieldPercentageComplete;
    static const QLatin1Constant FieldStatus;
#else
    Q_DECLARE_CUSTOM_ORGANIZER_DETAIL(QOrganizerTodoProgress, "TodoProgress")
    Q_DECLARE_LATIN1_CONSTANT(FieldFinishedDateTime, "FinishedDateTime");
    Q_DECLARE_LATIN1_CONSTANT(FieldPercentageComplete, "PercentageComplete");
    Q_DECLARE_LATIN1_CONSTANT(FieldStatus, "Status");
#endif

    void setFinishedDateTime(const QDateTime& finishedDateTime) {setValue(FieldFinishedDateTime, finishedDateTime);}
    QDateTime finishedDateTime() const {return value<QDateTime>(FieldFinishedDateTime);}

    void setPercentageComplete(int percentage)
    {
        if (percentage >=0 && percentage <= 100)
            setValue(FieldPercentageComplete, percentage);
    }
    int percentageComplete() const {return value<int>(FieldPercentageComplete);}

    enum Status {
        // what about: waited/blocked, and deferred?
        StatusNotStarted,
        StatusInProgress,
        StatusComplete,
    };

    void setStatus(Status status) {setValue(FieldStatus, (int) status);}
    Status status() const {return (Status) value<int>(FieldStatus);}
};

QTM_END_NAMESPACE

#endif

