/*
 *
 *  Quick Controller
 *
 *  Copyright (C) 2008-2009  Intel Corporation. All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms and conditions of the GNU General Public License,
 * version 2, as published by the Free Software Foundation.
 *
 * This program is distributed in the hope it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License for
 * more details.
 *
 * You should have received a copy of the GNU General Public License along with
 * this program; if not, write to the Free Software Foundation, Inc., 
 * 51 Franklin St - Fifth Floor, Boston, MA 02110-1301 USA.
 *
 */

/****************************************************************************
File Name:          CMPC_QCPBasicIF.h

Description:
    This file implements to call the interfaces of windows and Ubuntu.

        This class has following property:

         1.QCP_InitDCS                   Initialize the Device Control Service
         2.QCP_InitVolumeStatus          Get initalizal volume information
         3.QCP_InitBrightnessStatus      Get initalizal brightness information
         4.QCP_InitRotation              Launch autu rotation(Default mode)
         5.QCP_LCDBrightnessUp           Set Brightness up
         6.QCP_LCDBrightnessDown         Set Brightness down
         7.QCP_VolumeUp                  Set Volume up
         8.QCP_VolumeDown                Set Volume down
         9.QCP_VolumeMute                Set Mute mode
         10.QCP_ShowCursor               Launch the show cursor tool
         11.QCP_LaunchDisplayApp         Launch the Switch Display tool
         12.QCP_LaunchScreenCalApp       Launch the Screen calibrate
         13.QCP_ScreenRotationSwitch     Switch rotation mode
         14.QCP_SetCW                    Right direction rotation
         15.QCP_SetCCW                   Left direction rotation

Environment (opt):
    OS: Windows XP table and Ubuntu
    SE: CodeBlocks
Notes (opt):
  =====================================================================
  Revision   Revision History               Author     Date
  =====================================================================

  0.1        Create                       Chen Dequan   2008-7-20

  =====================================================================

****************************************************************************/
#ifndef _CMPC_QCP_BASIC_IF_H_
#define _CMPC_QCP_BASIC_IF_H_

#include "CMPC_QCPMain.h"
#include "CMPC_QCPDef.h"

class QCPBasicIF
{
    public:
        QCPBasicIF(){}
        virtual ~QCPBasicIF(){}

        virtual bool QCP_InitDCS() = 0;
        virtual bool QCP_InitBrightnessStatus(int *piBrightLevel) = 0;
        virtual bool QCP_LCDBrightnessUp(int iBrightLevel, int *piBrightLevel)= 0;
        virtual bool QCP_LCDBrightnessDown(int iBrightLevel, int *piBrightLevel) = 0;
        virtual bool QCP_SetLCDBrightnessLevel(int iBrightLevel) = 0;
        virtual bool QCP_InitVolumeStatus(int *piVolLevel, bool *pbMuteState) = 0;
        virtual bool QCP_VolumeUp(int *iVolLevel) = 0;
        virtual bool QCP_VolumeDown(int *iVolLevel) = 0;
        virtual bool QCP_SetVolumeLevel(int iVolLevel) = 0;
        virtual bool QCP_VolumeMute(int *iVolLevel, bool* bStatus) = 0;
        virtual bool QCP_GetCursorStatus() = 0;
        virtual void QCP_ShowCursor(wxString AppShowCursor) = 0;
        virtual void QCP_LaunchDisplayApp(wxString AppDisplay) = 0;
        virtual bool QCP_LaunchScreenCalApp(wxString AppPath) = 0;
        virtual bool QCP_InitRotation(BOOL* pbStatus) = 0;
        virtual bool QCP_ScreenRotationSwitch(BOOL* pbStatus) = 0;
        virtual void QCP_SetCW(CMPC_QCPDialog* pDlg) = 0;
        virtual void QCP_SetCCW(CMPC_QCPDialog* pDlg) = 0;
        virtual void QCP_Rotation180Degree(CMPC_QCPDialog* pDlg) = 0;
};


#endif
