/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#ifndef _IIO_SERVICE_H_
#define _IIO_SERVICE_H_

#include "PlatformService.h"

class IIOService : public PlatformService {
public:
        IIOService();
        void getDataFds(std::queue<int> &dataFdQueue);
        dataSelectMode getDataSelectMode() { return SELECT_MODE_READ; }
        bool handleEvents(int fd);
        int enumerateSensors(SensorEnumerator * enumerator, const xmlNodePtr ishRoot, std::vector<Sensor *> &sensors);
        int getNotifyFd() { return -1; }
        void handleNotify(int notification) {}
};

#endif
