#include "ISHGravity.h"
#include "Log.h"

struct gravity_raw {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct gravity_data {
        int64_t timestamp;
        int64_t timestamp0;
        int x;
        int y;
        int z;
} __attribute__ ((packed));

ISHGravity::ISHGravity(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHGravity::ISHGravity(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHGravity::~ISHGravity()
{

}

void ISHGravity::initialize()
{
        if (information.scale_android.size() == 3) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
        }
}

size_t ISHGravity::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct gravity_raw);

        if (bufSize % sizeof(struct gravity_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct gravity_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct gravity_raw *gravity = reinterpret_cast<const struct gravity_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = gravity[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = gravity[i].x * scaleX;
                mEvents[i].data[1] = gravity[i].y * scaleY;
                mEvents[i].data[2] = gravity[i].z * scaleZ;
        }
        return count;
}
