#include "ISHRotationVector.h"
#include "Log.h"

struct rotation_vector_raw {
        int64_t timestamp;
        int64_t timestamp0;
        short x;
        short y;
        short z;
        short w;
        unsigned char accuracy;
        unsigned char err_rad;
} __attribute__ ((packed));

struct rotation_vector_data {
        int64_t timestamp;
        int64_t timestamp0;
        short x;
        short y;
        short z;
        short w;
        unsigned char accuracy;
        unsigned char err_rad;
} __attribute__ ((packed));


ISHRotationVector::ISHRotationVector(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHRotationVector::ISHRotationVector(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHRotationVector::~ISHRotationVector()
{

}

void ISHRotationVector::initialize()
{
        if (information.scale_android.size() == 4) {
                scaleX = information.scale_android[0];
                scaleY = information.scale_android[1];
                scaleZ = information.scale_android[2];
                scaleW = information.scale_android[3];
                ALOGV_IF(VERBOSE, "%s line: %d %f %f %f", __FUNCTION__, __LINE__, scaleX, scaleY, scaleZ);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scaleX = 1.0;
                scaleY = 1.0;
                scaleZ = 1.0;
                scaleW = 1.0;
        }
}

size_t ISHRotationVector::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct rotation_vector_raw);

        if (bufSize % sizeof(struct rotation_vector_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct rotation_vector_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct rotation_vector_raw *rotation_vector = reinterpret_cast<const struct rotation_vector_raw *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = rotation_vector[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = rotation_vector[i].x * scaleX;
                mEvents[i].data[1] = rotation_vector[i].y * scaleY;
                mEvents[i].data[2] = rotation_vector[i].z * scaleZ;
                mEvents[i].data[3] = rotation_vector[i].w * scaleW;
        }
        return count;
}
