#include "ISHUserDefinedGesture.h"
#include "Log.h"

// LUID:0216000000000080
struct user_defined_gesture_raw {
        int64_t timestamp;
        int64_t timestamp0;
        uint8_t gesture_index;
        uint32_t score;
        uint16_t custom_usage;
} __attribute__ ((packed));

struct user_defined_gesture_aware {
        int64_t timestamp;
        uint8_t gesture_index;
        uint32_t score;
} __attribute__ ((packed));

ISHUserDefinedGesture::ISHUserDefinedGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHUserDefinedGesture::ISHUserDefinedGesture(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHUserDefinedGesture::~ISHUserDefinedGesture()
{

}

void ISHUserDefinedGesture::initialize()
{

}

size_t ISHUserDefinedGesture::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct user_defined_gesture_raw);

        if (bufSize % sizeof(struct user_defined_gesture_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct user_defined_gesture_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct user_defined_gesture_aware));

        const struct user_defined_gesture_raw *user_defined_gesture = reinterpret_cast<const struct user_defined_gesture_raw *>(buf);
        struct user_defined_gesture_aware *aware = reinterpret_cast<struct user_defined_gesture_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = user_defined_gesture[i].timestamp * US_TO_NS;
                aware[i].gesture_index = user_defined_gesture[i].gesture_index;
                aware[i].score = user_defined_gesture[i].score;
        }

        return count * sizeof(struct user_defined_gesture_aware);
}

size_t ISHUserDefinedGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct user_defined_gesture_raw);

        if (bufSize % sizeof(struct user_defined_gesture_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct user_defined_gesture_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct user_defined_gesture_raw *gesture = reinterpret_cast<const struct user_defined_gesture_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = gesture[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = gesture[i].gesture_index;
                mEvents[i].data[1] = gesture[i].score;
        }

        return count;
}
