/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHPickUpGesture.h"
#include "Log.h"

struct pickup_data {
        int64_t ts;
        short pickup;
} __attribute__ ((packed));

PSHPickUpGesture::PSHPickUpGesture(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service)
        :PSHSensor(device, information, data, service)
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

PSHPickUpGesture::~PSHPickUpGesture()
{

}

size_t PSHPickUpGesture::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct pickup_data);

        if (bufSize % sizeof(struct pickup_data) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct pickup_data));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct pickup_data *pickup = reinterpret_cast<const struct pickup_data *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = pickup[i].ts;
                mEvents[i].data[0] = pickup[i].pickup;
        }
        return count;
}
