#include "ISHInfrared.h"
#include "Log.h"

// sc_sensor_type: 0x253

struct _ir_data_t {
        int64_t timestamp;
        int64_t timestamp0;
        uint32_t infrared;
} __attribute__ ((packed));

ISHInfrared::ISHInfrared(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHSensor(device, information, data)
{
        initialize();
}

ISHInfrared::ISHInfrared(const Sensor * refSensor, const uint32_t serial_number)
        :ISHSensor(refSensor, serial_number)
{
        initialize();
}

ISHInfrared::~ISHInfrared()
{
        if (information.scale_android.size() == 1) {
                scale = information.scale_android[0];
                ALOGV_IF(VERBOSE, "%s line: %d %f", __FUNCTION__, __LINE__, scale);
        } else {
                ALOGW("%s line: %d invalid scale information: size: %d", __FUNCTION__, __LINE__, information.scale_android.size());
                scale = 1.0e-6;
        }
}

void ISHInfrared::initialize()
{

}

size_t ISHInfrared::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct _ir_data_t);

        if (bufSize % sizeof(struct _ir_data_t) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct _ir_data_t));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct _ir_data_t *infrared = reinterpret_cast<const struct _ir_data_t *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = infrared[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = infrared[i].infrared * scale;
        }

        return count;
}
