#include "ISHLift.h"
#include "Log.h"

// LUID: 0211000000000000

struct lift_raw {
        int64_t timestamp;
        int64_t timestamp0;
        char look;
        char vertical;
        unsigned short custom_usage;
} __attribute__ ((packed));

struct lift_aware {
        int64_t timestamp;
        char look;
        char vertical;
} __attribute__ ((packed));

ISHLift::ISHLift(const struct sensor_device_t &device, const sensor_additional_information_t &information, const ish_private_data_t &data)
        :ISHAwareSensor(device, information, data)
{
        initialize();
}

ISHLift::ISHLift(const Sensor * refSensor, const uint32_t serial_number)
        :ISHAwareSensor(refSensor, serial_number)
{
        initialize();
}

ISHLift::~ISHLift()
{

}

void ISHLift::initialize()
{
}

size_t ISHLift::convertToStreaming(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct lift_raw);

        if (bufSize % sizeof(struct lift_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct lift_raw));
                return 0;
        }

        reallocStreamingBuffer(count * sizeof(struct lift_aware));

        const struct lift_raw *lift = reinterpret_cast<const struct lift_raw *>(buf);
        struct lift_aware *aware = reinterpret_cast<struct lift_aware *>(mStreaming);
        for (size_t i = 0; i < count; i++) {
                aware[i].timestamp = lift[i].timestamp * US_TO_NS;
                aware[i].look = lift[i].look;
                aware[i].vertical = lift[i].vertical;
        }

        return count * sizeof(struct lift_aware);
}

size_t ISHLift::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct lift_raw);

        if (bufSize % sizeof(struct lift_raw) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct lift_raw));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct lift_raw *lift = reinterpret_cast<const struct lift_raw *>(buf);
        for (size_t i = 0; i < count; i++) {
                mEvents[i].timestamp = lift[i].timestamp * US_TO_NS;
                mEvents[i].data[0] = lift[i].look;
                mEvents[i].data[1] = lift[i].vertical;
        }

        return count;
}
