/*
 * Copyright (c) 2015 Intel Corporation
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

#include "PSHTiltDetector.h"
#include "Log.h"

struct tilt_detector_data {
        int64_t ts;
        short tiltd;
} __attribute__ ((packed));

PSHTiltDetector::PSHTiltDetector(const struct sensor_device_t &device, const sensor_additional_information_t &information, const psh_private_data_t &data, PSHService *service)
        :PSHSensor(device, information, data, service)
{
        this->device.flags |= SENSOR_FLAG_WAKE_UP;
}

PSHTiltDetector::~PSHTiltDetector()
{

}

size_t PSHTiltDetector::convertToEvent(const char * buf, size_t bufSize)
{
        size_t count = bufSize / sizeof(struct tilt_detector_data);

        if (bufSize % sizeof(struct tilt_detector_data) != 0) {
                ALOGE("%s line: %d Invalid size: %d unit size is: %d",
                      __FUNCTION__, __LINE__, bufSize, sizeof(struct tilt_detector_data));
                return 0;
        }

        reallocEventsBuffer(count);

        const struct tilt_detector_data *tilt_detector = reinterpret_cast<const struct tilt_detector_data *>(buf);
        for (int i = 0; i < count; i++) {
                mEvents[i].timestamp = tilt_detector[i].ts;
                mEvents[i].data[0] = tilt_detector[i].tiltd;
        }
        return count;
}
