/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          SESDataTools.h

Description:

    This file defines class SESDataTools.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __SESDATATOOLS_H__
#define __SESDATATOOLS_H__

#include <string>
#include "libsesdata.h"

namespace LibSESData
{
class CSESDataTools
{
private:
	CSESDataTools();
	virtual ~CSESDataTools();

public:
	static std::string GetHomeDir();
	static int GetLock(std::string);
	static int FileExist(std::string);
	static int StartupProgramAsynchronism(const std::string& path);
	static int StartupProgramBlocked(const std::string& path);
	static int IsInputValid(const std::string& checkedString,
			std::string& errorString);
	static int PopupBalloon(const std::string& summary,
			const std::string& body, std::string& errorString);
	static int IsStrongPassword(const std::string& password,
			std::string& errorString);
	static int OpenHelp(const std::string& filename, std::string& errorString);
	static int GetCurrentThemeName(std::string& strCurrentThemeName,
			std::string &strFont, std::string& errorString);
	static bool Compress(const std::string &msg, unsigned char** pucStr,
			unsigned long& iLen);
	static bool Uncompress(unsigned char** pucStr, std::string &msg,
			const unsigned long ul_FormLen);

	//added by lfeng
	static void TrimSpaceBeforeAndAfterString(std::string& message);
	static void TrimEnterCharacterOfString(std::string& message);

private:
	static const unsigned int MAX_STRING_INPUT;
	static const std::string NOTIFY_TIMER;
};
}

#endif /* __SESDATATOOLS_H__ */
