/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          LockScheduleData.h

Description:

    This file defines class LockScheduleData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __LOCKSCHEDULEDATA_H__
#define __LOCKSCHEDULEDATA_H__

#include "SESDataProvider.h"
#include "LockTimeSection.h"
#include "ManualLock.h"
#include <string>
#include <list>

namespace LibSESData
{
//TODO : jinxin review use the loadxml path .	//Done
//#define POLICY_PATH "/etc/ses/LockSchedule.xml"


class CLockScheduleData: public LibSESData::CSESDataProvider
{
public:
	CLockScheduleData();
	virtual ~CLockScheduleData();
	void FinalRelease();

protected:
	int DOM2Member();
	int Member2DOM();

private:
	int m_iAutoLock;
	int m_iManualLock;
	int m_iLockStatus;

	std::list<CLockTimeSection*>* m_pAutomaticLockTimeList;
	CManualLock* m_pManaulLock;

public:
	bool IsAutoLockEnable(void) const;
	bool IsManualLockEnable() const;
	bool Islocked();

	void SetAutoLock(int iStatus);
	void SetManualLock(int iStatus);
	//change Lock status

	void SetLockStatus(int iStatus);
	int GetLockStatus();

	//0 no item effect
	//1 first item effect
	//2 second item effect
	void SetManualLockOption(int iOptionValue);

	std::list<CLockTimeSection*> *GetPAutomaticLockTimeList() const;

	CManualLock *GetPManualLockInfo() const;

	void SetManualLockInfo(CManualLock * pManualLock);

	// TODO : jinxin review move to cpp file.  //Done
	// TODO : jinxin need check whether the pointer is self.	//Done
	void SetPAutomaticLockTimeList(std::list<CLockTimeSection*> *pAutomaticLockTimeList);

	// Clear Internal Data
	void Clear();

	int IsEqual(const CLockScheduleData& other);

private:
	int WeekDayString2Int(std::string strDay);
	std::string WeekDayInt2String(int iDay);

};

}

#endif /* __LOCKSCHEDULEDATA_H__ */
