/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          SESSystemSettingData.h

Description:

    This file defines class SESSystemSettingData.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                        Huang Miao  2008/9/16

  =====================================================================

****************************************************************************/

#ifndef __SESSYSTEMSETTINGDATA_H__
#define __SESSYSTEMSETTINGDATA_H__

#include "SESDataProvider.h"

namespace LibSESData
{
	class CSESSystemSettingData: public LibSESData::CSESDataProvider
	{
	public:
		CSESSystemSettingData();
		virtual ~CSESSystemSettingData();

	protected:
		int DOM2Member();
		int Member2DOM();


	public:

		//Modify by lx start 20081013: move to cpp
		int GetUSBStorageenabled() const;

		void SetUSBStorageenabled(int iUSBStorageenabled);
		//Modify by lx end

		//Add by lx start 20081025
		int GetNewStudentConnectDialogEnable() const;

		void SetNewStudentConnectDialogEnable(int iNewStudentConnectDialogEnable);

		int GetConnectPolicyAllow() const;

		void SetConnectPolicyAllow(int iConnectPolicyAllow);

		int GetAddToCurrentClassAllow() const;

		void SetAddToCurrentClassAllow(int iAddToCurrentClassAllow);
		//Add by lx end

		//Add by lx start 20081112
		int GetAutoDeployEnabled() const;

		void SetAutoDeployEnabled(int iAutoDeploy);
		//Add by lx end

		//Add by lx start 20081223
		int GetConnectionPort() const;

		void SetConnectionPort(int iConnectionPort);

		int GetDownloadCAPort() const;

		void SetDownloadCAPort(int iDownloadCAPort);
		//Add by lx end

		int IsEqual(const CSESSystemSettingData& other);

	private:
		int m_iUSBStorageenabled;

		int m_iNewStudentConnectDialogEnable;
		int m_iConnectPolicyAllow;
		int m_iAddToCurrentClassAllow;

		int m_iAutoDeploy;

		int m_iConnectionPort;
		int m_iDownloadCAPort;
	};

}

#endif /* __SESSYSTEMSETTINGDATA_H__ */
