/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CChangeIconDlg.h

Description:

    This file defines class CChangeIconDlg.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Qian di 2008/9/10

  =====================================================================

****************************************************************************/

#ifndef CCHANGEICONDLG_H_
#define CCHANGEICONDLG_H_

#include <gtk/gtk.h>
#include <string>
//qiand add the header for find Icons->
#include <unistd.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h>
#include <stdlib.h>
#include <vector>
//qiand add the header for find Icons<-

#include "CSESLog.h"
#include "libsesdata.h"
#include "SESDataTools.h"
#include <glib/gi18n.h>
#include "CSESWindowBase.h"

namespace LibSESGUI
{

class CChangeIconDlg :public CSESWindowBase
{
public:

	explicit CChangeIconDlg(string strDirPath, string strIconPath, string strCategoryName, string strEditName);
	virtual ~CChangeIconDlg();

public:

	int Init();
//	int Close();
//	int Show(GCallback cb, gpointer data);

	int FetchData(string& categoryName, string& iconPath);
	int FetchReturnStatus();

public:
	// GTK HANDLER
	static int GTK_OK_BTN_CLICKED(GtkWidget *widget, gpointer data);
	static int GTK_BROWSE_BTN_CLICKED(GtkWidget *widget, gpointer data);
	static int GTK_CANCEL_BTN_CLICKED(GtkWidget *widget, gpointer data);
	static void GtkOnIconViewSelectionChanged(GtkIconView *icon_view, gpointer user_data);

private:

	void OnOKBtnClicked();

	void OnBROWSEBtnClicked();

	void OnIconViewSelectionChanged();

	void initIconView(GtkListStore *store);

	//string TrimSpace(string strSource);

public:

	DIR *m_dp;
	struct dirent *m_entry;
	struct stat m_statbuf;
	string m_strIconDirPath;
	string m_strEditName;

private:
	// GTK Members
//	GtkWidget *window;
//	GtkWidget *m_FixBox;
	GtkWidget *m_gMainVbox;
	GtkWidget*	m_gHbox;
	GtkWidget* event_box;

	GtkListStore *m_gtkStore;
	GtkWidget *m_gScrolledWindow;
	GtkWidget *m_Icon_view;
	gchar * m_gIcon_name;

	GtkWidget *m_gCategoryName;
	GtkWidget *m_gCategoryPath;

	GtkWidget *m_gSelectedCategoryName;
	GtkWidget *m_gSelectedCategoryPath;

	GtkWidget *m_gOkBtn;
	GtkWidget *m_gCancelBtn;
	GtkWidget *m_gBrowseBtn;

	GdkPixbuf *m_Iconfile_pixbuf;
	gchar *m_gParent;
	string m_strImagePath;
	string m_strIconPath;
	string m_strDefaultImagePath;

	GtkWidget *m_LabelCategoryName;
	GtkWidget *m_InputCategoryName;
	GtkWidget *m_LabelName;
	GtkWidget *m_LabelShowName;
	GtkWidget *m_LabelPath;
	GtkWidget *m_LabelShowPath;

private:
	//string m_strIconPath;
	string m_strIconFullPath;
	string m_strDisplayName;
	int m_iReturnStatus; //1:OK , 0 Cancel

	enum
	{
		COL_PIXBUF 		= 0,
		COL_ICON_NAME 	= 1,
		COL_ICON_PATH	= 2,
		COL_SUM
	};

	vector<string> m_IconName;
};

}

#endif /* CChangeIconDlgDlg_H_ */
