/****************************************************************************

Copyright (c) 2009 Intel Corporation.  All rights reserved. 



DISCLAIMER OF WARRANTY

NEITHER INTEL NOR ITS SUPPLIERS MAKE ANY REPRESENTATION OR WARRANTY OR

CONDITION OF ANY KIND WHETHER EXPRESS OR IMPLIED (EITHER IN FACT OR BY

OPERATION OF LAW) WITH RESPECT TO THE SOURCE CODE.  INTEL AND ITS SUPPLIERS

EXPRESSLY DISCLAIM ALL WARRANTIES OR CONDITIONS OF MERCHANTABILITY OR

FITNESS FOR A PARTICULAR PURPOSE.  INTEL AND ITS SUPPLIERS DO NOT WARRANT

THAT THE SOURCE CODE IS ERROR-FREE OR THAT OPERATION OF THE SOURCE CODE WILL

BE SECURE OR UNINTERRUPTED AND HEREBY DISCLAIM ANY AND ALL LIABILITY ON

ACCOUNT THEREOF.  THERE IS ALSO NO IMPLIED WARRANTY OF NON-INFRINGEMENT.

SOURCE CODE IS LICENSED TO LICENSEE ON AN "AS IS" BASIS AND NEITHER INTEL

NOR ITS SUPPLIERS WILL PROVIDE ANY SUPPORT, ASSISTANCE, INSTALLATION,

TRAINING OR OTHER SERVICES.  INTEL AND ITS SUPPLIERS WILL NOT PROVIDE ANY

UPDATES, ENHANCEMENTS OR EXTENSIONS. 


File Name:          CSearchProgramBase.h

Description:

    This file defines class CSearchProgramBase.

Environment (opt):
    OS: Ubuntu
    SE: Eclipse

Notes (opt):

  =====================================================================

  Revision   Revision History               Author     Date

  =====================================================================

  0.1        Create                         Jin Xin    2008/9/10

  =====================================================================

****************************************************************************/

#ifndef CSEARCHPROGRAMBASE_H_
#define CSEARCHPROGRAMBASE_H_

#include "CSESWindowBase.h"
#include "libsesdata.h"
#include <glib/gi18n.h>

#include <gtk/gtk.h>
#include <set>
#include <string>

namespace LibSESGUI
{

class CSearchProgramBase : public CSESWindowBase
{
public:
	CSearchProgramBase();
	virtual ~CSearchProgramBase();

public:
	// Global GTK+ Handler
	static void GtkSearchBtnClicked(GtkWidget *widget, gpointer data);
	//static void GtkBrowseBtnClicked(GtkWidget *widget, gpointer data);
	//static void GtkCloseBtnClicked(GtkWidget *widget, gpointer data);
	static gboolean GtkOnCloseBtnClicked(GtkWidget *widget, GdkEvent *event, gpointer data);

public:
	virtual int Init() 					= 0;
	virtual int OnSearchBtnClicked() 	= 0;
	//virtual int OnBrowseBtnClicked(){};
	virtual int CancelSearch()			= 0;
//	virtual int Show();
//	int Hidden();
//	int Close();

	virtual int AttachBaseClassGTKHandler(CSearchProgramBase* pObj);

protected:
	// GTK+ Controls
	//GtkWidget *window;
	GtkWidget* m_gVbox;
	GtkWidget* m_gLableSearch;
	GtkWidget* m_gEditSearchPath;
	GtkWidget *m_gShowMessage;
	GtkWidget* m_gHbox;
	GtkWidget* m_gHbox1;
	GtkWidget* m_gHboxShowMessage;
	GtkWidget* event_box;
	GtkWidget* m_gSearchBtn;
	//GtkWidget* m_gBrowseBtn;
	GtkWidget* m_gProgressBar;

	GdkColor m_RedColor;
	GdkColor m_BlackColor;

protected:
	CSearchProgramBase* m_pSubclassPtr;
	std::string			m_strSearchPath;
	std::string			m_strFolderPath;

	int					m_iSearchCancelID;
	bool				m_bIsCancel;
//	LibSESData::CSearchResultData	m_SearchResult;
	int 				m_iSearchMode;
};

}

#endif /* CSEARCHPROGRAMBASE_H_ */
