/******************************************************************************
 * File Name    : TeacherInfoWindow.cpp
 * Created      : 2008/9/10
 * Author       : lfeng@neusoft.com
 * Model        :
 * Description  :
 ******************************************************************************/
#include <gtk/gtk.h>
#include <glib/gi18n.h>
#include <iostream>
#include <algorithm>
#include <list>
#include <string>
#include <unistd.h>
#include "TeacherInfoWindow.h"
#include "PublicFunc.h"
#include "seslib.h"
#include "SESCommonDef.h"

using namespace std;
using namespace LibSESData;
using namespace IPCAPI;
using namespace LibSESGUI;

#define TEACHER_WINDOW_BORDER_WIDTH 1
#define TEACHER_WINDOW_WIDTH 330
#define TEACHER_WINDOW_HEIGHT 160
#define TEACHER_WINDOW_ENTRY_WIDTH 200
#define TEACHER_WINDOW_ENTRY_HEIGHT 25

/******************************************************************************
 * Function Name: TeacherInfoWindow
 * Description  : Constructor of TeacherInfoWindow
 * Date         : 2008/9/10
 * Parameter    : pTeacherApiRef
 * Return Code  : OK, 		return 0
 *              : FAILURE, 	return -1
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
TeacherInfoWindow::TeacherInfoWindow()
						: m_gWindow (NULL)
						, m_gCourseNameEntry (NULL)
						, m_gTeacherNameEntry (NULL)
{
	CSESLog::WriteLine("TeacherInfoWindow::TeacherInfoWindow>>Start");
	//m_gWindow = NULL;
	//m_gCourseNameEntry = NULL;
	//m_gTeacherNameEntry = NULL;

//	m_pTeacherInfoData = new CTeacherInfoData();

	CSESLog::WriteLine("TeacherInfoWindow::TeacherInfoWindow<<End");
}
/******************************************************************************
 * Function Name: ~TeacherInfoWindow
 * Description  : Destructor of TeacherInfoWindow
 * Date         : 2008/9/10
 * Parameter    : pTeacherApiRef
 * Return Code  :
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
TeacherInfoWindow::~TeacherInfoWindow()
{
	CSESLog::WriteLine("TeacherInfoWindow::~TeacherInfoWindow>>Start");
//	if(NULL != m_pTeacherInfoData)
//	{
//		delete m_pTeacherInfoData;
//		m_pTeacherInfoData = NULL;
//	}
	CSESLog::WriteLine("TeacherInfoWindow::~TeacherInfoWindow<<End");
}
/******************************************************************************
 * Function Name: CreateWindow
 * Description  : Create window
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void TeacherInfoWindow::CreateWindow()
{
	CSESLog::WriteLine("TeacherInfoWindow::CreateWindow>>Start");
	m_gWindow = gtk_window_new(GTK_WINDOW_TOPLEVEL);
	g_signal_connect(G_OBJECT(m_gWindow), "delete-event", G_CALLBACK(WindowClosing), this);
	gtk_window_set_position(GTK_WINDOW(m_gWindow), GTK_WIN_POS_CENTER_ON_PARENT);
	gtk_container_set_border_width(GTK_CONTAINER(m_gWindow), TEACHER_WINDOW_BORDER_WIDTH);
	gtk_widget_set_size_request(m_gWindow, TEACHER_WINDOW_WIDTH, TEACHER_WINDOW_HEIGHT);
	gtk_window_set_title(GTK_WINDOW(m_gWindow), _("Teacher Information"));
	// added by dengjing
	gtk_window_set_wmclass (GTK_WINDOW(m_gWindow), _("Teacher Information"), "SES");
	gtk_window_set_type_hint(GTK_WINDOW (m_gWindow), GDK_WINDOW_TYPE_HINT_DIALOG);
	gtk_window_set_resizable(GTK_WINDOW(m_gWindow), FALSE);
	gtk_window_set_skip_taskbar_hint(GTK_WINDOW(m_gWindow), TRUE);

	string iconPath("");
    iconPath.append(SES_RESOURCE_IMAGE_PATH);
    iconPath.append("shellcontroller_main.png");

    GError** error = NULL;
    gtk_window_set_icon_from_file(GTK_WINDOW(m_gWindow), SES_SHELL_CONTROLLER_ICON.c_str(), error);
	CSESLog::WriteLine("TeacherInfoWindow::CreateWindow<<End");

}
/******************************************************************************
 * Function Name: TeacherInitialInformationWindow_init
 * Description  : Init TeacherInitialInformationWindow
 * Date         : 2008/9/10
 * Parameter    : VOID
 * Return Code  : OK		return 0;
 * 				  FAILURE	return -1;
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void TeacherInfoWindow::Init()
{
	CSESLog::WriteLine("TeacherInfoWindow::TeacherInitialInformationWindow_init>>Start");
	string TeacherID;
	string TeacherName;

	CreateWindow();

	//m_pTeacherInfoData = new CTeacherInfoData();;
	string path = CONFIG_FILE_DIR + TEACHER_INFO;
	m_pTeacherInfoData.LoadFromFile(path.c_str());
	m_pOriginalTeacherName = m_pTeacherInfoData.GetTeacherName();
	m_pOriginalCourseName = m_pTeacherInfoData.GetCourse();

	GtkWidget* pVbox = gtk_vbox_new (FALSE ,0);
	gtk_container_add (GTK_CONTAINER (m_gWindow), pVbox);

	GtkWidget* pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pVbox), pHbox, FALSE, FALSE, 20);

	GtkWidget* pLabel = gtk_label_new (_("Teacher Name:"));
	gtk_widget_set_tooltip_text (pLabel, _("Teacher Name:"));
	gtk_label_set_width_chars (GTK_LABEL(pLabel), 12);
	gtk_box_pack_start (GTK_BOX (pHbox), pLabel, FALSE, FALSE, 10);

	m_gTeacherNameEntry = gtk_entry_new ();
	gtk_widget_set_size_request(m_gTeacherNameEntry, TEACHER_WINDOW_ENTRY_WIDTH, TEACHER_WINDOW_ENTRY_HEIGHT);
	gtk_box_pack_end (GTK_BOX (pHbox), m_gTeacherNameEntry, FALSE, FALSE, 10);
	gtk_entry_set_text (GTK_ENTRY (m_gTeacherNameEntry), m_pTeacherInfoData.GetTeacherName().c_str());

	pHbox = gtk_hbox_new(FALSE, 0);
	gtk_box_pack_start (GTK_BOX (pVbox), pHbox, FALSE, FALSE, 5);

	pLabel = gtk_label_new (_("Course Name:"));
	gtk_widget_set_tooltip_text (pLabel, _("Course Name:"));
	gtk_label_set_width_chars (GTK_LABEL(pLabel), 12);
	gtk_box_pack_start (GTK_BOX (pHbox), pLabel, FALSE, FALSE, 10);

	m_gCourseNameEntry = gtk_entry_new ();
	gtk_widget_set_size_request(m_gCourseNameEntry, TEACHER_WINDOW_ENTRY_WIDTH, TEACHER_WINDOW_ENTRY_HEIGHT);
	gtk_box_pack_end (GTK_BOX (pHbox), m_gCourseNameEntry, FALSE, FALSE, 10);
	gtk_entry_set_text (GTK_ENTRY (m_gCourseNameEntry), m_pTeacherInfoData.GetCourse().c_str());

	pHbox = gtk_hbox_new (FALSE, 0);
	gtk_box_pack_end (GTK_BOX (pVbox), pHbox, FALSE, FALSE, 10);

	GtkWidget* pButton = gtk_button_new_with_label(_("OK"));
	gtk_widget_set_tooltip_text (pButton, _("OK"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	g_signal_connect(G_OBJECT (pButton), "clicked", G_CALLBACK (OkBtnClickedStatic), this);
	gtk_box_pack_end (GTK_BOX (pHbox), pButton, FALSE, FALSE, 10);

	pButton = gtk_button_new_with_label(_("Cancel"));
	gtk_widget_set_tooltip_text (pButton, _("Cancel"));
	gtk_widget_set_size_request(pButton, SES_BUTTON_WIDTH, SES_BUTTON_HEIGHT);
	g_signal_connect(G_OBJECT (pButton), "clicked", G_CALLBACK (CancelBtnClickedStatic), this);
	gtk_box_pack_end (GTK_BOX (pHbox), pButton, FALSE, FALSE, 0);




	CSESLog::WriteLine("TeacherInfoWindow::TeacherInitialInformationWindow_init<<End");
}


/******************************************************************************
 * Function Name: OK_button_clicked_static
 * Description  : Ok button click event
 * Date         : 2008/9/10
 * Parameter    : widget		OK button
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void TeacherInfoWindow::OkBtnClickedStatic(GtkWidget* widget, gpointer data)
{
	CSESLog::WriteLine("TeacherInfoWindow::OK_button_clicked_static>>Start");
	TeacherInfoWindow* ptr = (TeacherInfoWindow*)data;
	string teacherName = gtk_entry_get_text (GTK_ENTRY (ptr->m_gTeacherNameEntry));
	PublicFunc::TrimString(teacherName);
	string courseName = gtk_entry_get_text (GTK_ENTRY (ptr->m_gCourseNameEntry));
	PublicFunc::TrimString(courseName);
	if(0<teacherName.size() && MAX_VALID_STRING_SIZE>=teacherName.size())
	{
		if(0 < courseName.size() && MAX_VALID_STRING_SIZE >= courseName.size())
		{
			if(ptr->m_pTeacherInfoData.GetTeacherName()!=teacherName)
			{
				if(true == ptr->HasInvalidCharacters(teacherName))
				{
					string message(_("Teacher name contains invalid characters!"));
					CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
					gtk_widget_grab_focus(ptr->m_gTeacherNameEntry);
				}
				else
				{
					if(true == ptr->HasInvalidCharacters(courseName))
					{
						string message(_("Course name contains invalid characters!"));
						CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
						gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
					}
					else
					{
						string teacherXML("");
						int errCode;
						string path = CONFIG_FILE_DIR + TEACHER_INFO;
						ptr->m_pTeacherInfoData.SetCourse(courseName);
						ptr->m_pTeacherInfoData.SetTeacherName(teacherName);
						ptr->m_pTeacherInfoData.Save2File(path.c_str());
						ptr->m_pTeacherInfoData.Save2String(teacherXML);
						ptr->m_pTeacherAPI->UpdateTeacherInfo(teacherXML, errCode);
						gtk_widget_destroy(ptr->m_gWindow);
					}
				}
			}
			else
			{
				if(ptr->m_pTeacherInfoData.GetCourse()!=courseName)
				{
					if(true == ptr->HasInvalidCharacters(courseName))
					{
						string message(_("Course name contains invalid characters!"));
						CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
						gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
					}
					else
					{
						string teacherXML("");
						int errCode;
						string path = CONFIG_FILE_DIR + TEACHER_INFO;
						ptr->m_pTeacherInfoData.SetCourse(courseName);
						ptr->m_pTeacherInfoData.Save2File(path.c_str());
						ptr->m_pTeacherInfoData.Save2String(teacherXML);
						ptr->m_pTeacherAPI->UpdateTeacherInfo(teacherXML, errCode);
						gtk_widget_destroy(ptr->m_gWindow);
					}
				}
				else
				{
					gtk_widget_destroy(ptr->m_gWindow);
				}
			}
		}
		else
		{
			string message(_("The length of course name must be between 1~64 characters!"));
			CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
			gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
		}
	}
	else
	{
		string message(_("The length of teacher name must be between 1~64 characters!"));
		CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
		gtk_widget_grab_focus(ptr->m_gTeacherNameEntry);
	}
	CSESLog::WriteLine("TeacherInfoWindow::OK_button_clicked_static<<End");
}

/******************************************************************************
 * Function Name: HasInvalidCharacters
 * Description  : Justify if the given string has wrong characters
 * Date         : 2008/9/10
 * Parameter    : str string
 * Return Code  : Has invalid characters		return 1
 * 				  Right							retrun 0
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool TeacherInfoWindow::HasInvalidCharacters(string& str)
{
	string ABC = "/\\:*?\"<>|&";
	int result = 0;
	string::iterator iter;
	if(str.find_first_of(ABC) != string::npos)
	{
		result = 1;
	}
	else
	{
		result = 0;
	}
	return result;
}
/******************************************************************************
 * Function Name: Cancel_button_clicked_static
 * Description  : Cancel button click event
 * Date         : 2008/9/10
 * Parameter    : widget		OK button
 * 				  data			user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void TeacherInfoWindow::CancelBtnClickedStatic(GtkWidget* widget, gpointer data)
{
	CSESLog::WriteLine("TeacherInfoWindow::Cancel_button_clicked_static>>Start");
	TeacherInfoWindow* ptr = (TeacherInfoWindow*)data;
	//GtkWidget* dialog = NULL;
	if(true == ptr->CompareOriginalData())
	{
//		dialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//												   GTK_DIALOG_MODAL,
//												   GTK_MESSAGE_QUESTION,
//												   GTK_BUTTONS_YES_NO,
//												   _("Do you want to save the changes?"));
//		gtk_window_set_title(GTK_WINDOW(dialog), "Information");
	    string message(_("Do you want to save the changes?"));
	    int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
		if(GTK_RESPONSE_YES == result)
		{
			string teacherName = gtk_entry_get_text (GTK_ENTRY (ptr->m_gTeacherNameEntry));
			PublicFunc::TrimString(teacherName);
			string courseName = gtk_entry_get_text (GTK_ENTRY (ptr->m_gCourseNameEntry));
			PublicFunc::TrimString(courseName);
			if(0<teacherName.size() && MAX_VALID_STRING_SIZE>=teacherName.size())
			{
				if(0 < courseName.size() && MAX_VALID_STRING_SIZE >= courseName.size())
				{
					if(ptr->m_pTeacherInfoData.GetTeacherName() != teacherName)
					{
						if(true == ptr->HasInvalidCharacters(teacherName))
						{
							//gtk_widget_destroy(dialog);
							string message(_("Teacher name contains invalid characters!"));
							CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
							gtk_widget_grab_focus(ptr->m_gTeacherNameEntry);
						}
						else
						{
							if(true == ptr->HasInvalidCharacters(courseName))
							{
								//gtk_widget_destroy(dialog);
								string message(_("Course name contains invalid characters!"));
								CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
								gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
							}
							else
							{
								//gtk_widget_destroy(dialog);
								string teacherXML("");
								int errCode;
								string path = CONFIG_FILE_DIR + TEACHER_INFO;
								ptr->m_pTeacherInfoData.SetTeacherName(teacherName);
								ptr->m_pTeacherInfoData.SetCourse(courseName);
								ptr->m_pTeacherInfoData.Save2File(path.c_str());
								ptr->m_pTeacherInfoData.Save2String(teacherXML);
								ptr->m_pTeacherAPI->UpdateTeacherInfo(teacherXML, errCode);
								gtk_widget_destroy(ptr->m_gWindow);
							}

						}
					}
					else
					{
						if(true == ptr->HasInvalidCharacters(courseName))
						{
							//gtk_widget_destroy(dialog);
							string message(_("Course name contains invalid characters!"));
							CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
							gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
						}
						else
						{
							//gtk_widget_destroy(dialog);
							string teacherXML("");
							int errCode;
							string path = CONFIG_FILE_DIR + TEACHER_INFO;
							ptr->m_pTeacherInfoData.SetCourse(courseName);
							ptr->m_pTeacherInfoData.Save2File(path.c_str());
							ptr->m_pTeacherInfoData.Save2String(teacherXML);
							ptr->m_pTeacherAPI->UpdateTeacherInfo(teacherXML, errCode);
							gtk_widget_destroy(ptr->m_gWindow);
						}
					}
				}
				else
				{
					//gtk_widget_destroy(dialog);
					string message(_("The length of course name must be between 1~64 characters!"));
					CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
					gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
				}
			}
			else
			{
				//gtk_widget_destroy(dialog);
				string message(_("The length of teacher name must be between 1~64 characters!"));
				CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
				gtk_widget_grab_focus(ptr->m_gTeacherNameEntry);
			}
		}
		else
		{
			//gtk_widget_destroy(dialog);
			gtk_widget_destroy(ptr->m_gWindow);
		}
	}
	else
	{
		gtk_widget_destroy(ptr->m_gWindow);
	}
	CSESLog::WriteLine("TeacherInfoWindow::Cancel_button_clicked_static<<End");
}
/******************************************************************************
 * Function Name: WindowClosing
 * Description  : Window closing event
 * Date         : 2008/11/10
 * Parameter    : gtkwidget		main window
 * 				  event			close window event
 * 				  data			user data
 * Return Code  : True			Dont close window
 * 				  False			close window
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool TeacherInfoWindow::WindowClosing(GtkWidget* gtkwidget, GdkEvent* event, gpointer data)
{
	CSESLog::WriteLine("TeacherInfoWindow::WindowClosing>>Start");
	TeacherInfoWindow* ptr = (TeacherInfoWindow*)data;
	//GtkWidget* dialog = NULL;
	if(true == ptr->CompareOriginalData())
	{
//		dialog = gtk_message_dialog_new (GTK_WINDOW (ptr->m_gWindow),
//												   GTK_DIALOG_MODAL,
//												   GTK_MESSAGE_QUESTION,
//												   GTK_BUTTONS_YES_NO,
//												   _("Do you want to save the changes?"));
//		gtk_window_set_title(GTK_WINDOW(dialog), "Information");

		string message(_("Do you want to save the changes?"));
		int result = CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_QUESTION, GTK_BUTTONS_YES_NO);
		if(GTK_RESPONSE_YES == result)
		{
			string teacherName = gtk_entry_get_text (GTK_ENTRY (ptr->m_gTeacherNameEntry));
			PublicFunc::TrimString(teacherName);
			string courseName = gtk_entry_get_text (GTK_ENTRY (ptr->m_gCourseNameEntry));
			PublicFunc::TrimString(courseName);
			if(0<teacherName.size() && MAX_VALID_STRING_SIZE>=teacherName.size())
			{
				if(0 < courseName.size() && MAX_VALID_STRING_SIZE >= courseName.size())
				{
					if(ptr->m_pTeacherInfoData.GetTeacherName() != teacherName)
					{
						if(true == ptr->HasInvalidCharacters(teacherName))
						{
							//gtk_widget_destroy(dialog);
							string message(_("Teacher name contains invalid characters!"));
							CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
							gtk_widget_grab_focus(ptr->m_gTeacherNameEntry);
							return true;
						}
						else
						{
							if(true == ptr->HasInvalidCharacters(courseName))
							{
								//gtk_widget_destroy(dialog);
								string message(_("Course name contains invalid characters!"));
								CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
								gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
								return true;
							}
							else
							{
								//gtk_widget_destroy(dialog);
								string teacherXML("");
								int errCode;
								string path = CONFIG_FILE_DIR + TEACHER_INFO;
								ptr->m_pTeacherInfoData.SetTeacherName(teacherName);
								ptr->m_pTeacherInfoData.SetCourse(courseName);
								ptr->m_pTeacherInfoData.Save2File(path.c_str());
								ptr->m_pTeacherInfoData.Save2String(teacherXML);
								ptr->m_pTeacherAPI->UpdateTeacherInfo(teacherXML, errCode);
								return false;
							}
						}
					}
					else
					{
						if(true == ptr->HasInvalidCharacters(courseName))
						{
							//gtk_widget_destroy(dialog);
							string message(_("Course name contains invalid characters!"));
							CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
							gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
							return true;
						}
						else
						{
							//gtk_widget_destroy(dialog);
							string teacherXML("");
							int errCode;
							string path = CONFIG_FILE_DIR + TEACHER_INFO;
							ptr->m_pTeacherInfoData.SetCourse(courseName);
							ptr->m_pTeacherInfoData.Save2File(path.c_str());
							ptr->m_pTeacherInfoData.Save2String(teacherXML);
							ptr->m_pTeacherAPI->UpdateTeacherInfo(teacherXML, errCode);
							//gtk_widget_destroy(ptr->m_gWindow);
							return false;
						}
					}
				}
				else
				{
					//gtk_widget_destroy(dialog);
					string message(_("The length of course name must be between 1~64 characters!"));
					CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
					gtk_widget_grab_focus(ptr->m_gCourseNameEntry);
					return true;
				}
			}
			else
			{
				//gtk_widget_destroy(dialog);
				string message(_("The length of teacher name must be between 1~64 characters!"));
				CMessageBox::Show(message, ptr->m_gWindow, GTK_MESSAGE_WARNING, GTK_BUTTONS_OK);
				gtk_widget_grab_focus(ptr->m_gTeacherNameEntry);
				return true;
			}
		}
		else
		{
			//gtk_widget_destroy(dialog);
			return false;
		}
	}
	else
	{
		return false;
	}
	CSESLog::WriteLine("TeacherInfoWindow::WindowClosing<<End");
}
/******************************************************************************
 * Function Name: ShowModal
 * Description  : Make TeacherInfoWindow in modal style
 * Date         : 2008/9/10
 * Parameter    : parentwindow		parent window
 * 				  cb				callback function
 * 				  data				user data
 * Return Code  : VOID
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
void TeacherInfoWindow::ShowModal(GtkWidget* parenwindow, GCallback cb, gpointer data)
{
	CSESLog::WriteLine("TeacherInfoWindow::ShowModal>>Start");
	gtk_window_set_transient_for(GTK_WINDOW(m_gWindow), GTK_WINDOW(parenwindow));
	gtk_window_set_modal(GTK_WINDOW(m_gWindow), true);
	g_signal_connect(G_OBJECT(m_gWindow), "destroy", G_CALLBACK(cb), data);
	gtk_widget_show_all(m_gWindow);
	CSESLog::WriteLine("TeacherInfoWindow::ShowModal<<End");
}
//void TeacherInfoWindow::TeacherNameChanged(GtkEntry* entry, gpointer data)
//{
//
//}
/******************************************************************************
 * Function Name: CompareOriginalData
 * Description  : Compare Original Data
 * Date         : 2008/11/10
 * Parameter    : VOID
 * Return Code  : True		Same
 * 				  False		Not Same
 * Author       : lfeng@neusoft.com
 ******************************************************************************/
bool TeacherInfoWindow::CompareOriginalData()
{
	string teacherName = gtk_entry_get_text(GTK_ENTRY(m_gTeacherNameEntry));
	string courseName = gtk_entry_get_text(GTK_ENTRY(m_gCourseNameEntry));
	return teacherName.compare(m_pOriginalTeacherName)||courseName.compare(m_pOriginalCourseName);
}
