#ifndef CSESPUBLISHSERVICE_H_
#define CSESPUBLISHSERVICE_H_

#define SERVICE_TYPE "_sescontroller._tcp"
#define SERVICE_PORT 8888


#include <string>
#include <vector>
#include <avahi-client/client.h>
#include <avahi-client/publish.h>
#include <avahi-common/alternative.h>
#include <avahi-common/simple-watch.h>
#include <avahi-common/malloc.h>
#include <avahi-common/error.h>
#include <avahi-common/timeval.h>

//struct hostInfo
//{
//	std::string IP;
//	std::string netcardname;
//};
//typedef struct hostInfo HostInfo_t;

class CSESPublishService
{
public:
  CSESPublishService(void);
  ~CSESPublishService(void);

  static void UpdateServiceInfo(const std::string& Name,
		  const std::string& Comment,
		  int iPort,
		  int iDownloadCAPort);

  bool start();
  void stop();


private:
  static std::string m_Name;
  static std::string m_Comment;
  static int m_iPort;
  static int m_iDownloadCAPort;
//  static std::string m_IP;
//  static std::vector< HostInfo_t > m_IPList;

  static AvahiEntryGroup* m_group;
  static AvahiSimplePoll* m_simple_poll;
  static AvahiClient *m_client;
  pthread_t SESPublisherThreadID;
  static bool bLoop;
  static bool bUpdate;
private:
  static void
  client_callback(AvahiClient *c, AvahiClientState state,
      AVAHI_GCC_UNUSED void * userdata);
  static void
  create_services(AvahiClient *c);
  static void
  entry_group_callback(AvahiEntryGroup *g, AvahiEntryGroupState state,
      AVAHI_GCC_UNUSED void *userdata);
  static void
  modify_callback(AVAHI_GCC_UNUSED AvahiTimeout *e, void *userdata);

  static void* worker(void *arg);
  static void GenerateServiceName();
//  static std::string GetHostIP();
//  static void GetHostIPList(std::vector<HostInfo_t>& IPList);
//  static bool isIPListChanged(std::vector<HostInfo_t>& IPList);
};

#endif /*CSESPUBLISHSERVICE_H_*/
