#ifndef OPERATIONMANAGER_H_
#define OPERATIONMANAGER_H_

#include <string>
#include <list>
#include <IntfData.h>
#include "ace/Synch.h"
#include "TSDCommon.h"
//forwarding declaration

class RequFactory;
class CStudentMgr;
class RegMgr;
class RequBase;
class CSESPublishService;
class DetectIP;
class ACE_SSL_Context;
namespace IPCAPI
{
class IPCTeacherDaemonAPI;
}

//end of forwarding declaration


class COperationManager
{
public:
	COperationManager();
	virtual ~COperationManager();

	int work();

	void StuMgrCallback(IPCAPI::CIntfData& netMsg);

	//void RegMgrCallback(IPCAPI::CIntfData& netMsg);

	void StuMgrDisconnectCallback(std::string& studentID);
	void StuMgrChangeStdInfoCallback(std::string & studentID, std::string& strXML);

	void RegMgrCallback();

	int ChangePassword(const std::string& OldPassword,
			const std::string& NewPassword);

	int VerifyPassword(const std::string& Password,const std::string& path);

	int Verifycertificate(const std::string& path="");

	int ImportCertificate(const std::string& Path="",const std::string& newPath=NEWCAPATH);

	void StopController(IPCAPI::CIntfData* localMsg);
	void StartController(IPCAPI::CIntfData* localMsg);




	bool CheckOperationTimeOut();
	void HandleSTUDENT_HEARTBEAT(IPCAPI::CIntfData& netMsg);

	void CancelOperation(IPCAPI::CIntfData* localMsg);
	void NotifyStudentStatusChanged(const std::string& SID, int iStatus);
	void HandleByRequestList(IPCAPI::CIntfData& netMsg);
	bool SetStudentTime(std::string SID);
	bool RequirePolicySchedule(std::string SID);
	bool SavePolicySchedule(IPCAPI::CIntfData* localMsg);
	bool UpdatePolicyInfo(IPCAPI::CIntfData* localMsg);

	void KickoffAllStudents();
	CSESPublishService* Publisher;
private:
	void ProcessTimeOutRequest();
	static void* DetectIPChanged(void * arg);
	ACE_Thread_Mutex* OP_List_lock;
	std::list<RequBase*> requestList;
	double timeOutInterval;
	bool isStarted;
	std::string ControllerName;
	std::string ControllerDescription;
	CStudentMgr* myStudentManager;
	RequFactory* myRequFactory;
	RegMgr* myRegMgr;
	IPCAPI::IPCTeacherDaemonAPI* TeacherDaemonAPI;

	DetectIP*	m_DetectIP;
	pthread_t SESDetectIPThreadID;
	int			m_iPort;
	int			m_iDownloadCAPort;
};

#endif /*OPERATIONMANAGER_H_*/
