#ifndef _CSTUDENTMGR_H_HEADER_INCLUDED_
#define _CSTUDENTMGR_H_HEADER_INCLUDED_

#include <ace/Thread_Manager.h>

#include "TSDCommon.h"
#include <vector>
#include <ace/Singleton.h>
#include <ace/Synch_Traits.h>
#include <ace/Thread.h>
#include <ace/OS_main.h>
#include <ace/ACE.h>
#include <ace/Reactor.h>

#include <ace/Timer_Queue.h>
#include <list>
#include <IntfData.h>
//#include <time>
#include <ace/TP_Reactor.h>
class Student;
class RegMgr;
class COperationManager;
class CNetSSLClientWrapper;
using namespace IPCAPI;
using namespace std;
class CStudentMgr: public ACE_Event_Handler
{
public:
	//Don't use CStudentMgr()

	CStudentMgr();

	virtual ~CStudentMgr();

	//use instance() to get the Singleton<CStudentMgr>
	static CStudentMgr *instance(void);

public:

	bool Open();

	// Close this instance
	void Close();

	void RegisterCOperationManager(COperationManager* cOperationManager);

	//Send intfData
	bool Send(const CIntfData& intfData);

	bool SendAll(const CIntfData & intfData);

	bool KickOffAllStudent(const CIntfData& bybCIntfData);

	bool KickOffStudentList(const CIntfData& bybCIntfData, list<string>& list);

	void GetStudentList(CIntfData& intfData);

	bool GetStudentDetailedInfo(std::string& studentID,
			StudentInfo_t& studentInfo_t);

	//for heartbeat
	bool UpdateStudentStatus(std::string& studentID, int iLock, int istates);

	void UpdateLockPolicyData(std::string& studentID, long int lastUpdateTime,
			std::string deployname);

	bool SetStudentDetailedInfo(std::string& studentID,
			StudentInfo_t& studentInfo_t);

	bool UpdateLockPolicy(std::string& studentID, std::string lockPolicy);
	bool GetLockPolicy(std::string& studentID, std::string& lockPolicy);
	//for  OPMGR
	void DelStudent(const std::string& studentID);

	void WillDelStudent(const std::string& studentID);
	bool GetStudentforNotifyTeacher(StudentInfo_t& studentInfo_t);
	bool ControlNewStudent(std::string& studentID, bool bAllow,
			CIntfData& cIntfData);
	bool IsStudentExist(std::string& studentID);
public:

	void Acquire(){ACE_OS::thread_mutex_lock(&mc_mgr_lock);}
	void Release(){ACE_OS::thread_mutex_unlock(&mc_mgr_lock);}

	bool HandleHeartBeat(CIntfData & intfData);

	virtual int handle_timeout(const ACE_Time_Value &tv, const void *arg);

	ACE_HANDLE get_handle(void) const;

	void AddHandle(Student* student);

	void RemoveHandle(Student* student);

	void RemoveHandle(const std::string& studentId);

	void RemoveHandleAll();

	static void* StuMgrThread(void *arg);

	//These  methods will not be used.

	//will replace by RegMgr.AddNewStudent
	//bool AddNewStudent(const CIntfData& intfData);

	bool IsTimeOut();

	//??do what?
	void UpdateStudent(const CIntfData& intfData);

	//Set Receive CallBack
	//void Setmp_RecvCallBack(void(*p)(CIntfData& intfData));

	//for StudentMgr
	bool AddNewStudent(Student* student);

	//for Student
	void COperationManagerCallBack(CIntfData& intfData);

	void COperationManagerDisconnectCallBack(std::string& studentID);

	// will del this method.Del a student from mc_student_vector
	void DelStudent(const CIntfData& intfData);

	void SetParameter();

	bool GetStudentIDVector(std::vector<std::string>& vector);
private:

	void StuMgrOpen();

	// Clear mc_student_vector not use any more
	void Clear();
private:
	time_t m_TimerNew;
	ACE_TP_Reactor* mp_TP_Reactor;
	ACE_Reactor* mp_Reactor;
	COperationManager* m_pCOperationManager;

	//static CStudentMgr* m_instance;

	std::vector<Student*> m_StudentVector;

	CNetSSLClientWrapper* conn;

	std::vector<std::string> m_StudentIDListr;

	ACE_thread_mutex_t mc_mgr_lock;

	bool bStart;

	bool bFirst;
	//Not use any more.
	//void (*mp_RecvCallBack)(CIntfData& intfData);

};

#endif
