#!/bin/bash 
# compatibilityNotification.sh - OEM platform compatibility notify
# Copyright (C) 2013 Penk Chen <penk.chen@canonical.com>
# 
# Usage: compatibilityNotification [ -u ] [ -d ]
#       -u  Display "Unsupported Hardware" notification and system ID
#       -d  Display "Development Version" notification and buildstamp
# 
# compiled by shc [1] for obfuscation: shc -v -r -T -f compatibilityNotification.sh
# [1] http://www.datsi.fi.upm.es/~frosal/sources/shc.html

. /usr/share/stella-base-config/getID.sh
while getopts ":ud" o; do
	case "${o}" in
	u) DISPLAY=:0.0 /usr/bin/notify-send -i error 'Unsupported Hardware' "System ID: $ID"
	;;
	d) DISPLAY=:0.0 /usr/bin/notify-send -i /var/log/platform-compatibility-qrcode.png -h string:x-canonical-private-synchronous:1 "`cat /var/log/platform-compatibility-summary`" "`cat /var/log/platform-compatibility-info`"
	;;
	esac
done
shift $((OPTIND-1))
